/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.session;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.mockftpserver.core.MockFtpServerException;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.socket.DefaultServerSocketFactory;
import org.mockftpserver.core.socket.DefaultSocketFactory;
import org.mockftpserver.core.socket.ServerSocketFactory;
import org.mockftpserver.core.socket.SocketFactory;
import org.mockftpserver.core.util.Assert;

public class DefaultSession
implements Session {
    private static final Logger LOG = Logger.getLogger((Class)DefaultSession.class);
    private static final String END_OF_LINE = "\r\n";
    protected static final int DEFAULT_CLIENT_DATA_PORT = 21;
    protected SocketFactory socketFactory = new DefaultSocketFactory();
    protected ServerSocketFactory serverSocketFactory = new DefaultServerSocketFactory();
    private BufferedReader controlConnectionReader;
    private Writer controlConnectionWriter;
    private Socket controlSocket;
    private Socket dataSocket;
    ServerSocket passiveModeDataSocket;
    private InputStream dataInputStream;
    private OutputStream dataOutputStream;
    private Map commandHandlers;
    private int clientDataPort = 21;
    private InetAddress clientHost;
    private InetAddress serverHost;
    private Map attributes = new HashMap();
    private volatile boolean terminate = false;

    public DefaultSession(Socket controlSocket, Map commandHandlers) {
        Assert.notNull(controlSocket, "controlSocket");
        Assert.notNull(commandHandlers, "commandHandlers");
        this.controlSocket = controlSocket;
        this.commandHandlers = commandHandlers;
        this.serverHost = controlSocket.getLocalAddress();
    }

    public InetAddress getClientHost() {
        return this.controlSocket.getInetAddress();
    }

    public InetAddress getServerHost() {
        return this.serverHost;
    }

    public void sendReply(int code, String text) {
        this.assertValidReplyCode(code);
        StringBuffer buffer = new StringBuffer(Integer.toString(code));
        if (text != null && text.length() > 0) {
            String replyText = text.trim();
            if (replyText.indexOf("\n") != -1) {
                int lastIndex = replyText.lastIndexOf("\n");
                buffer.append("-");
                for (int i = 0; i < replyText.length(); ++i) {
                    char c = replyText.charAt(i);
                    buffer.append(c);
                    if (i != lastIndex) continue;
                    buffer.append(Integer.toString(code));
                    buffer.append(" ");
                }
            } else {
                buffer.append(" ");
                buffer.append(replyText);
            }
        }
        LOG.debug((Object)("Sending Reply [" + buffer.toString() + "]"));
        this.writeLineToControlConnection(buffer.toString());
    }

    public void openDataConnection() {
        try {
            if (this.passiveModeDataSocket != null) {
                LOG.debug((Object)("Waiting for (passive mode) client connection from client host [" + this.clientHost + "] on port " + this.passiveModeDataSocket.getLocalPort()));
                try {
                    this.dataSocket = this.passiveModeDataSocket.accept();
                    LOG.debug((Object)("Successful (passive mode) client connection to port " + this.passiveModeDataSocket.getLocalPort()));
                }
                catch (SocketTimeoutException e) {
                    throw new MockFtpServerException(e);
                }
            } else {
                Assert.notNull(this.clientHost, "clientHost");
                LOG.debug((Object)("Connecting to client host [" + this.clientHost + "] on data port [" + this.clientDataPort + "]"));
                this.dataSocket = this.socketFactory.createSocket(this.clientHost, this.clientDataPort);
            }
            this.dataOutputStream = this.dataSocket.getOutputStream();
            this.dataInputStream = this.dataSocket.getInputStream();
        }
        catch (IOException e) {
            throw new MockFtpServerException(e);
        }
    }

    public int switchToPassiveMode() {
        try {
            this.passiveModeDataSocket = this.serverSocketFactory.createServerSocket(0);
            return this.passiveModeDataSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new MockFtpServerException("Error opening passive mode server data socket", e);
        }
    }

    public void closeDataConnection() {
        try {
            LOG.debug((Object)"Flushing and closing client data socket");
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
            this.dataInputStream.close();
            this.dataSocket.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing client data socket", (Throwable)e);
        }
    }

    private void writeLineToControlConnection(String line) {
        try {
            this.controlConnectionWriter.write(line + END_OF_LINE);
            this.controlConnectionWriter.flush();
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing to control connection", (Throwable)e);
            throw new MockFtpServerException("Error writing to control connection", e);
        }
    }

    public void close() {
        LOG.trace((Object)"close()");
        this.terminate = true;
    }

    public void sendData(byte[] data, int numBytes) {
        Assert.notNull(data, "data");
        try {
            this.dataOutputStream.write(data, 0, numBytes);
        }
        catch (IOException e) {
            throw new MockFtpServerException(e);
        }
    }

    public byte[] readData() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = this.dataInputStream.read()) != -1) {
                bytes.write(b);
            }
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new MockFtpServerException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    Command readCommand() {
        socketReadIntervalMilliseconds = 20L;
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.terminate) {
                    return null;
                }
                if (this.controlConnectionReader.ready()) {
                    command = this.controlConnectionReader.readLine();
                    DefaultSession.LOG.info((Object)("Received command: [" + command + "]"));
                    return this.parseCommand(command);
                }
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new MockFtpServerException(e);
                }
                break;
            }
        }
        catch (IOException e) {
            DefaultSession.LOG.error((Object)"Read failed", (Throwable)e);
            throw new MockFtpServerException(e);
        }
        {
            ** while (true)
        }
    }

    Command parseCommand(String commandString) {
        String name;
        Assert.notNullOrEmpty(commandString, "commandString");
        ArrayList<String> parameters = new ArrayList<String>();
        int indexOfFirstSpace = commandString.indexOf(" ");
        if (indexOfFirstSpace != -1) {
            name = commandString.substring(0, indexOfFirstSpace);
            StringTokenizer tokenizer = new StringTokenizer(commandString.substring(indexOfFirstSpace + 1), ",");
            while (tokenizer.hasMoreTokens()) {
                parameters.add(tokenizer.nextToken());
            }
        } else {
            name = commandString;
        }
        String[] parametersArray = new String[parameters.size()];
        return new Command(name, parameters.toArray(parametersArray));
    }

    public void setClientDataHost(InetAddress clientHost) {
        this.clientHost = clientHost;
    }

    public void setClientDataPort(int dataPort) {
        this.clientDataPort = dataPort;
        if (this.passiveModeDataSocket != null) {
            try {
                this.passiveModeDataSocket.close();
            }
            catch (IOException e) {
                throw new MockFtpServerException(e);
            }
            this.passiveModeDataSocket = null;
        }
    }

    public void run() {
        try {
            InputStream inputStream = this.controlSocket.getInputStream();
            OutputStream outputStream = this.controlSocket.getOutputStream();
            this.controlConnectionReader = new BufferedReader(new InputStreamReader(inputStream));
            this.controlConnectionWriter = new PrintWriter(outputStream, true);
            LOG.debug((Object)"Starting the session...");
            CommandHandler connectCommandHandler = (CommandHandler)this.commandHandlers.get("CONNECT");
            connectCommandHandler.handleCommand(new Command("CONNECT", new String[0]), this);
            while (!this.terminate) {
                this.readAndProcessCommand();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new MockFtpServerException(e);
        }
        finally {
            LOG.debug((Object)"Cleaning up the session");
            try {
                this.controlConnectionReader.close();
                this.controlConnectionWriter.close();
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            LOG.debug((Object)"Session stopped.");
        }
    }

    private void readAndProcessCommand() throws Exception {
        Command command = this.readCommand();
        if (command != null) {
            String normalizedCommandName = Command.normalizeName(command.getName());
            CommandHandler commandHandler = (CommandHandler)this.commandHandlers.get(normalizedCommandName);
            if (commandHandler == null) {
                commandHandler = (CommandHandler)this.commandHandlers.get("UNSUPPORTED");
            }
            Assert.notNull(commandHandler, "CommandHandler for command [" + normalizedCommandName + "]");
            commandHandler.handleCommand(command, this);
        }
    }

    private void assertValidReplyCode(int replyCode) {
        Assert.isTrue(replyCode > 0, "The number [" + replyCode + "] is not a valid reply code");
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "name");
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "name");
        this.attributes.put(name, value);
    }

    public Set getAttributeNames() {
        return this.attributes.keySet();
    }

    public void removeAttribute(String name) {
        Assert.notNull(name, "name");
        this.attributes.remove(name);
    }
}

