/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NettyHttpRequest;
import org.mockserver.model.StringBody;

public class NettyToMockServerRequestMapper {
    public HttpRequest mapNettyRequestToMockServerRequest(NettyHttpRequest mockServerHttpRequest) {
        HttpRequest httpRequest = new HttpRequest();
        if (mockServerHttpRequest != null) {
            this.setMethod(httpRequest, mockServerHttpRequest);
            this.setUrl(httpRequest, mockServerHttpRequest);
            this.setPath(httpRequest, mockServerHttpRequest);
            this.setQueryString(httpRequest, mockServerHttpRequest);
            this.setBody(httpRequest, mockServerHttpRequest);
            this.setHeaders(httpRequest, mockServerHttpRequest);
            this.setCookies(httpRequest, mockServerHttpRequest);
        }
        return httpRequest;
    }

    private void setMethod(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        httpRequest.withMethod(mockServerHttpRequest.getMethod().name());
    }

    private void setUrl(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        String hostAndPort = mockServerHttpRequest.headers().get("Host");
        httpRequest.withURL("http" + (mockServerHttpRequest.isSecure() ? "s" : "") + "://" + (hostAndPort != null ? hostAndPort : "localhost") + mockServerHttpRequest.getUri());
    }

    private void setPath(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        httpRequest.withPath(mockServerHttpRequest.path());
    }

    private void setQueryString(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        httpRequest.withQueryStringParameters(mockServerHttpRequest.parameters());
    }

    private void setBody(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        if (mockServerHttpRequest.content() != null) {
            byte[] bodyBytes = new byte[mockServerHttpRequest.content().readableBytes()];
            mockServerHttpRequest.content().readBytes(bodyBytes);
            httpRequest.setRawBodyBytes(bodyBytes);
            httpRequest.withBody((Body)new StringBody(new String(bodyBytes, Charsets.UTF_8), Body.Type.STRING));
        }
    }

    private void setHeaders(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        HttpHeaders headers = mockServerHttpRequest.headers();
        for (String headerName : headers.names()) {
            httpRequest.withHeader(new Header(headerName, (Collection)headers.getAll(headerName)));
        }
    }

    private void setCookies(HttpRequest httpRequest, NettyHttpRequest mockServerHttpRequest) {
        for (String cookieHeader : mockServerHttpRequest.headers().getAll("Cookie")) {
            for (String cookie : Splitter.on((String)";").split((CharSequence)cookieHeader)) {
                if (cookie.trim().isEmpty()) continue;
                httpRequest.withCookie(new Cookie(StringUtils.substringBefore((String)cookie, (String)"=").trim(), new String[]{StringUtils.substringAfter((String)cookie, (String)"=").trim()}));
            }
        }
    }
}

