/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.server.bootstrap;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.smsc.server.bootstrap.SS7ServiceMBean;
import org.mobicents.smsc.server.bootstrap.Version;

public class SS7Service
extends ServiceMBeanSupport
implements SS7ServiceMBean {
    private static final Logger logger = Logger.getLogger(SS7Service.class);
    private Object stack;
    private String jndiName;
    private final String serviceName;
    private static final String rLogo = " ]]]]]]]]] ";
    private static final String lLogo = " [[[[[[[[[ ";

    public SS7Service(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getSS7ServiceName() {
        return this.serviceName;
    }

    public void startService() throws Exception {
        this.rebind(this.stack);
        logger.info((Object)this.generateMessageWithLogo("service started"));
    }

    private String generateMessageWithLogo(String message) {
        return lLogo + this.getSS7Name() + " " + this.getSS7Version() + " " + message + rLogo;
    }

    @Override
    public String getSS7Name() {
        String name = Version.instance.getProperty("name");
        if (name != null) {
            return name;
        }
        return "RestComm SMSC";
    }

    @Override
    public String getSS7Vendor() {
        String vendor = Version.instance.getProperty("vendor");
        if (vendor != null) {
            return vendor;
        }
        return "TeleStax";
    }

    @Override
    public String getSS7Version() {
        String version = Version.instance.getProperty("version");
        if (version != null) {
            return version;
        }
        return "2.0";
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    public Object getStack() {
        return this.stack;
    }

    public void setStack(Object stack) {
        this.stack = stack;
    }

    public void stopService() {
        try {
            this.unbind(this.jndiName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)this.generateMessageWithLogo("service stopped"));
    }

    @Override
    public boolean isStarted() {
        return this.getState() == 3;
    }

    private void rebind(Object stack) throws NamingException {
        Context ctx = new InitialContext();
        String[] tokens = this.jndiName.split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (tokens[i].trim().length() <= 0) continue;
            try {
                ctx = (Context)ctx.lookup(tokens[i]);
                continue;
            }
            catch (NamingException e) {
                ctx = ctx.createSubcontext(tokens[i]);
            }
        }
        ctx.bind(tokens[tokens.length - 1], stack);
    }

    private void unbind(String jndiName) throws NamingException {
        InitialContext initialContext = new InitialContext();
        initialContext.unbind(jndiName);
    }
}

