/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.isup.ra;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.slee.Address;
import javax.slee.SLEEException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import org.mobicents.protocols.ss7.isup.ISUPEvent;
import org.mobicents.protocols.ss7.isup.ISUPListener;
import org.mobicents.protocols.ss7.isup.ISUPMessageFactory;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ISUPProvider;
import org.mobicents.protocols.ss7.isup.ISUPTimeoutEvent;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.message.ConfusionMessage;
import org.mobicents.protocols.ss7.isup.message.ISUPMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;
import org.mobicents.slee.resources.isup.ra.FireableEventTypeCache;
import org.mobicents.slee.resources.isup.ra.FireableEventTypeFilter;
import org.mobicents.slee.resources.isup.ra.ISUPActivityHandle;
import org.mobicents.slee.resources.ss7.isup.events.BlockedEvent;
import org.mobicents.slee.resources.ss7.isup.events.TimeoutEvent;
import org.mobicents.slee.resources.ss7.isup.ratype.CircuitActivity;
import org.mobicents.slee.resources.ss7.isup.ratype.RAISUPProvider;

public class IsupResourceAdaptor
implements ResourceAdaptor,
ISUPListener {
    private Tracer tracer;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookupFacility = null;
    private FireableEventTypeCache eventTypeCache;
    private FireableEventTypeFilter eventTypeFilter;
    private ResourceAdaptorContext raContext;
    private static final int EVENT_FLAGS = IsupResourceAdaptor.getEventFlags();
    private static final int ACTIVITY_FLAGS = IsupResourceAdaptor.getActivityFlags();
    private ConcurrentHashMap<ActivityHandle, CircuitActivity> activities = new ConcurrentHashMap();
    private RAISUPProviderImpl raProvider;
    private static final String CONF_ISUP_JNDI = "isupJndi";
    private String isupJndi = null;
    private ISUPProvider isupProvider;
    private boolean transportUp = false;
    private int localspc;
    private int ni;

    private static int getEventFlags() {
        int eventFlags = 128;
        EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        return eventFlags;
    }

    private static int getActivityFlags() {
        return 2;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("IsupResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookupFacility = context.getEventLookupFacility();
        this.eventTypeCache = new FireableEventTypeCache(this.tracer);
        this.eventTypeFilter = new FireableEventTypeFilter();
    }

    public void unsetResourceAdaptorContext() {
        this.tracer = null;
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventLookupFacility = null;
        this.eventTypeCache = null;
        this.eventTypeFilter = null;
    }

    public void raConfigure(ConfigProperties configProperties) {
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Configuring ISUPRA: " + this.raContext.getEntityName());
            }
            this.isupJndi = (String)configProperties.getProperty(CONF_ISUP_JNDI).getValue();
        }
        catch (Exception e) {
            this.tracer.severe("Configuring of ISUP RA failed ", (Throwable)e);
        }
        this.raProvider = new RAISUPProviderImpl();
    }

    public void raUnconfigure() {
    }

    public void raActive() {
        try {
            InitialContext ic = new InitialContext();
            this.isupProvider = (ISUPProvider)ic.lookup(this.isupJndi);
            this.tracer.info("Sucssefully connected to ISUP service[" + this.isupJndi + "]");
            this.isupProvider.addListener((ISUPListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to activate ISUP RA ", (Throwable)e);
        }
    }

    public void raStopping() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void raInactive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void raVerifyConfiguration(ConfigProperties configProperties) throws InvalidConfigurationException {
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Verifying configuring ISUPA: " + this.raContext.getEntityName());
            }
            this.isupJndi = (String)configProperties.getProperty(CONF_ISUP_JNDI).getValue();
            if (this.isupJndi == null) {
                throw new InvalidConfigurationException("ISUP JNDI lookup name cannot be null");
            }
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Failed to test configuration options!", (Throwable)e);
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventTypeFilter.serviceActive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventTypeFilter.serviceStopping(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventTypeFilter.serviceInactive(receivableService);
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle key) {
        return this.activities.get(key);
    }

    public ActivityHandle getActivityHandle(Object act) {
        if (act instanceof CircuitActivity) {
            CircuitActivity activity = (CircuitActivity)act;
            return this.createActivityHandle(activity);
        }
        return null;
    }

    public void administrativeRemove(ActivityHandle handle) {
        if (this.activities.containsKey(handle)) {
            // empty if block
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void activityEnded(ActivityHandle handle) {
        this.activities.remove(handle);
    }

    public void activityUnreferenced(ActivityHandle handle) {
    }

    protected void fireEvent(FireableEventType eventType, Object activity, Object event) {
        ActivityHandle handle = this.getActivityHandle(activity);
        try {
            this.sleeEndpoint.fireEvent(handle, eventType, event, null, null, EVENT_FLAGS);
            this.tracer.info("Fired event: " + eventType);
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to fire event", e);
        }
    }

    private ActivityHandle createActivityHandle(CircuitActivity ca) {
        long txKey = ca.getTransactionKey();
        return new ISUPActivityHandle(txKey);
    }

    public void onEvent(ISUPEvent event) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Received Message, code: " + event.getMessage().getMessageType().getCode());
        }
        String eventName = null;
        switch (event.getMessage().getMessageType().getCode()) {
            case 9: {
                eventName = "ANSWER";
                break;
            }
            case 65: {
                eventName = "APPLICATION_TRANSPORT";
                break;
            }
            case 6: {
                eventName = "ADDRESS_COMPLETE";
                break;
            }
            case 19: {
                eventName = "BLOCKING";
                break;
            }
            case 21: {
                eventName = "BLOCKING_ACK";
                break;
            }
            case 44: {
                eventName = "CALL_PROGRESS";
                break;
            }
            case 49: {
                eventName = "CHARGE_INFORMATION";
                break;
            }
            case 24: {
                eventName = "CIRCUIT_GROUP_BLOCKING";
                break;
            }
            case 26: {
                eventName = "CIRCUIT_GROUP_BLOCKING_ACK";
                break;
            }
            case 42: {
                eventName = "CIRCUIT_GROUP_QUERY";
                break;
            }
            case 43: {
                eventName = "CIRCUIT_GROUP_QUERY_RESPONSE";
                break;
            }
            case 23: {
                eventName = "CIRCUIT_GROUP_RESET";
                break;
            }
            case 41: {
                eventName = "CIRCUIT_GROUP_RESET_ACK";
                break;
            }
            case 25: {
                eventName = "CIRCUIT_GROUP_UNBLOCKING";
                break;
            }
            case 27: {
                eventName = "CIRCUIT_GROUP_UNBLOCKING_ACK";
                break;
            }
            case 7: {
                eventName = "CONNECT";
                break;
            }
            case 17: {
                eventName = "CONTINUITY_CHECK_REQUEST";
                break;
            }
            case 5: {
                eventName = "CONTINUITY";
                break;
            }
            case 32: {
                eventName = "FACILITY_ACCPETED";
                break;
            }
            case 33: {
                eventName = "FACILITY_REJECTED";
                break;
            }
            case 8: {
                eventName = "FORWARD_TRANSFER";
                break;
            }
            case 54: {
                eventName = "IDENTIFICATION_REQUEST";
                break;
            }
            case 55: {
                eventName = "IDENTIFICATION_RESPONSE";
                break;
            }
            case 1: {
                eventName = "INITIAL_ADDRESS_MESSAGE";
                break;
            }
            case 64: {
                eventName = "LOOP_PREVENTION";
                break;
            }
            case 36: {
                eventName = "LOOPBACK_ACK";
                break;
            }
            case 50: {
                eventName = "NETWORK_RESOURCE_MANAGEMENT";
                break;
            }
            case 48: {
                eventName = "OVERLOAD";
                break;
            }
            case 40: {
                eventName = "PASS_ALONG";
                break;
            }
            case 66: {
                eventName = "PRERELEASE_INFORMATION";
                break;
            }
            case 16: {
                eventName = "RELEASE_COMPLETE";
                break;
            }
            case 12: {
                eventName = "RELEASE";
                break;
            }
            case 18: {
                eventName = "RESET_CIRCUIT";
                break;
            }
            case 14: {
                eventName = "RESUME";
                break;
            }
            case 2: {
                eventName = "SUBSEQUENT_ADDRESS";
                break;
            }
            case 67: {
                eventName = "SUBSEQUENT_DIRECTORY_NUMBER";
                break;
            }
            case 13: {
                eventName = "SUSPEND";
                break;
            }
            case 20: {
                eventName = "UNBLOCKING";
                break;
            }
            case 22: {
                eventName = "UNBLOCKING_ACK";
                break;
            }
            case 46: {
                eventName = "UNEQUIPPED_CIC";
                break;
            }
            case 45: {
                eventName = "USER_TO_USER_INFORMATION";
                break;
            }
            case 53: {
                eventName = "USER_PART_AVAILABLE";
                break;
            }
            case 52: {
                eventName = "USER_PART_TEST";
                break;
            }
            default: {
                this.tracer.severe("Received unkown event code: " + event.getMessage().getMessageType().getCode());
                return;
            }
        }
        FireableEventType eventType = this.eventTypeCache.getEventType(this.eventLookupFacility, eventName);
        long tx = CircuitActivity.generateTransactionKey((int)event.getMessage().getCircuitIdentificationCode().getCIC(), (int)event.getDpc());
        CircuitActivity ca = (CircuitActivity)this.getActivity(new ISUPActivityHandle(tx));
        if (ca == null) {
            if (this.eventTypeFilter.filterInitialEvent(eventType)) {
                this.tracer.info("event " + eventName + " filtered");
                ConfusionMessage cm = this.raProvider.getMessageFactory().createCNF(event.getMessage().getCircuitIdentificationCode().getCIC());
                CauseIndicators ci = this.raProvider.getParameterFactory().createCauseIndicators();
                ci.setLocation(10);
                ci.setCauseValue(95);
                cm.setCauseIndicators(ci);
                try {
                    this.raProvider.sendMessage((ISUPMessage)cm, event.getDpc());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return;
            }
            try {
                ca = this.raProvider.createCircuitActivity(event.getMessage(), event.getDpc());
            }
            catch (ActivityAlreadyExistsException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (SLEEException e) {
                e.printStackTrace();
            }
            catch (StartActivityException e) {
                e.printStackTrace();
            }
        } else if (this.eventTypeFilter.filterEvent(eventType) && this.eventTypeFilter.filterInitialEvent(eventType)) {
            this.tracer.info("event " + eventName + " filtered");
            ConfusionMessage cm = this.raProvider.getMessageFactory().createCNF(event.getMessage().getCircuitIdentificationCode().getCIC());
            CauseIndicators ci = this.raProvider.getParameterFactory().createCauseIndicators();
            ci.setLocation(10);
            ci.setCauseValue(95);
            cm.setCauseIndicators(ci);
            try {
                this.raProvider.sendMessage((ISUPMessage)cm, event.getDpc());
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        this.fireEvent(eventType, ca, event.getMessage());
    }

    public void onTimeout(ISUPTimeoutEvent event) {
        ISUPActivityHandle handle = new ISUPActivityHandle(CircuitActivity.generateTransactionKey((int)event.getMessage().getCircuitIdentificationCode().getCIC(), (int)event.getDpc()));
        if (this.activities.containsKey(handle)) {
            TimeoutEvent te = new TimeoutEvent(event.getMessage(), event.getTimerId());
            FireableEventType eventType = this.eventTypeCache.getEventType(this.eventLookupFacility, "TRANSACTION_TIMEOUT");
            if (this.eventTypeFilter.filterEvent(eventType)) {
                this.tracer.info("event TRANSACTION_TIMEOUT filtered");
                return;
            }
            this.fireEvent(eventType, this.getActivity(handle), te);
        }
    }

    public void onTransportDown() {
        this.transportUp = false;
    }

    public void onTransportUp() {
        this.transportUp = true;
    }

    private class RAISUPProviderImpl
    implements RAISUPProvider {
        private RAISUPProviderImpl() {
        }

        public CircuitActivity createCircuitActivity(ISUPMessage arg0, int dpc) throws IllegalArgumentException, ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
            ISUPActivityHandle handle = new ISUPActivityHandle(CircuitActivity.generateTransactionKey((int)arg0.getCircuitIdentificationCode().getCIC(), (int)dpc));
            if (IsupResourceAdaptor.this.activities.containsKey(handle)) {
                throw new ActivityAlreadyExistsException("Circuit activity already exists");
            }
            CircuitActivity activity = new CircuitActivity(arg0, dpc, (RAISUPProvider)this);
            handle = IsupResourceAdaptor.this.createActivityHandle(activity);
            IsupResourceAdaptor.this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)activity, ACTIVITY_FLAGS);
            IsupResourceAdaptor.this.activities.putIfAbsent(handle, activity);
            return activity;
        }

        public ISUPMessageFactory getMessageFactory() {
            return IsupResourceAdaptor.this.isupProvider.getMessageFactory();
        }

        public ISUPParameterFactory getParameterFactory() {
            return IsupResourceAdaptor.this.isupProvider.getParameterFactory();
        }

        public void sendMessage(ISUPMessage arg0, int dpc) throws ParameterException, IOException {
            IsupResourceAdaptor.this.isupProvider.sendMessage(arg0, dpc);
        }

        public void notifyBlockedChannel(int cic, int dpc) {
            ISUPActivityHandle handle = new ISUPActivityHandle(CircuitActivity.generateTransactionKey((int)cic, (int)dpc));
            if (IsupResourceAdaptor.this.activities.containsKey(handle)) {
                BlockedEvent be = new BlockedEvent(cic, dpc);
                FireableEventType eventType = IsupResourceAdaptor.this.eventTypeCache.getEventType(IsupResourceAdaptor.this.eventLookupFacility, "BLOCKED");
                if (IsupResourceAdaptor.this.eventTypeFilter.filterEvent(eventType)) {
                    IsupResourceAdaptor.this.tracer.info("event BLOCKED filtered");
                    return;
                }
                IsupResourceAdaptor.this.fireEvent(eventType, IsupResourceAdaptor.this.getActivity(handle), be);
            }
        }

        public void notifyResetChannel(int cic, int dpc) {
            ISUPActivityHandle handle = new ISUPActivityHandle(CircuitActivity.generateTransactionKey((int)cic, (int)dpc));
            if (IsupResourceAdaptor.this.activities.containsKey(handle)) {
                BlockedEvent be = new BlockedEvent(cic, dpc);
                FireableEventType eventType = IsupResourceAdaptor.this.eventTypeCache.getEventType(IsupResourceAdaptor.this.eventLookupFacility, "RESET");
                if (IsupResourceAdaptor.this.eventTypeFilter.filterEvent(eventType)) {
                    IsupResourceAdaptor.this.tracer.info("event RESET filtered");
                    return;
                }
                IsupResourceAdaptor.this.fireEvent(eventType, IsupResourceAdaptor.this.getActivity(handle), be);
            }
        }

        public void cancelTimer(int cic, int dpc, int timerId) {
            IsupResourceAdaptor.this.isupProvider.cancelTimer(cic, dpc, timerId);
        }

        public void endActivity(CircuitActivity ac) {
            IsupResourceAdaptor.this.isupProvider.cancelAllTimers(ac.getCIC(), ac.getDPC());
            ActivityHandle handle = IsupResourceAdaptor.this.getActivityHandle(ac);
            IsupResourceAdaptor.this.sleeEndpoint.endActivity(handle);
            IsupResourceAdaptor.this.activityEnded(handle);
        }

        public boolean isTransportUp() {
            return IsupResourceAdaptor.this.transportUp;
        }
    }
}

