/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.srtp;

import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.tls.DatagramTransport;

public class NioUdpTransport
implements DatagramTransport {
    private static final Logger logger = Logger.getLogger(NioUdpTransport.class);
    public static final int DEFAULT_MTU = 1500;
    private static final int MIN_IP_OVERHEAD = 20;
    private static final int MAX_IP_OVERHEAD = 84;
    private static final int UDP_OVERHEAD = 8;
    public static final int MAX_DELAY = 10000;
    private final DatagramChannel channel;
    private int mtu;
    private final int receiveLimit;
    private final int sendLimit;
    private long startTime;

    public NioUdpTransport(DatagramChannel channel) {
        if (!channel.isConnected()) {
            throw new IllegalArgumentException("The datagram channel must be connected");
        }
        this.channel = channel;
        try {
            NetworkInterface inet = NetworkInterface.getByInetAddress(channel.socket().getLocalAddress());
            this.mtu = inet == null ? 0 : inet.getMTU();
        }
        catch (SocketException e) {
            logger.warn((Object)("Could not discover Network Interface for current channel, setting MTU to 1500. Reason: " + e.getMessage()), (Throwable)e);
            this.mtu = 1500;
        }
        this.receiveLimit = Math.max(0, this.mtu - 20 - 8);
        this.sendLimit = Math.max(0, this.mtu - 84 - 8);
        this.startTime = System.currentTimeMillis();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public int getReceiveLimit() throws IOException {
        return this.receiveLimit;
    }

    public int getSendLimit() throws IOException {
        return this.sendLimit;
    }

    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        if (this.hasTimeout()) {
            throw new IllegalStateException("Handshake is taking too long! (>10000ms");
        }
        ByteBuffer buffer = ByteBuffer.wrap(buf, off, len);
        return this.channel.read(buffer);
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        if (len > this.getSendLimit()) {
            // empty if block
        }
        if (this.hasTimeout()) {
            throw new IllegalStateException("Handshake is taking too long! (>10000ms");
        }
        ByteBuffer buffer = ByteBuffer.wrap(buf, off, len);
        this.channel.send(buffer, this.channel.getRemoteAddress());
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    private boolean hasTimeout() {
        return System.currentTimeMillis() - this.startTime > 10000L;
    }
}

