/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.srtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.TlsServer;
import org.mobicents.media.server.impl.rtp.crypto.DtlsSrtpServer;
import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;

public class DtlsHandler
implements PacketHandler,
DatagramTransport {
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private static final Logger logger = Logger.getLogger(DtlsHandler.class);
    public static final int DEFAULT_MTU = 1500;
    private static final int MIN_IP_OVERHEAD = 20;
    private static final int MAX_IP_OVERHEAD = 84;
    private static final int UDP_OVERHEAD = 8;
    public static final int MAX_DELAY = 10000;
    private int pipelinePriority = 0;
    private int mtu = 1500;
    private final int receiveLimit = Math.max(0, this.mtu - 20 - 8);
    private final int sendLimit = Math.max(0, this.mtu - 84 - 8);
    private DtlsSrtpServer server = new DtlsSrtpServer();
    private DatagramChannel channel;
    private final Queue<ByteBuffer> rxQueue = new ConcurrentLinkedQueue<ByteBuffer>();
    private volatile boolean handshakeComplete = false;
    private volatile boolean handshakeFailed = false;
    private volatile boolean handshaking = false;
    private Thread worker;
    private String localHashFunction = "SHA-256";
    private String remoteHashFunction = "";
    private String remoteFingerprint = "";
    private String localFingerprint = "";
    private long startTime = 0L;
    private final List<DtlsListener> listeners = new ArrayList<DtlsListener>();
    private PacketTransformer srtpEncoder;
    private PacketTransformer srtpDecoder;
    private PacketTransformer srtcpEncoder;
    private PacketTransformer srtcpDecoder;

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    public void addListener(DtlsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isHandshakeFailed() {
        return this.handshakeFailed;
    }

    public boolean isHandshaking() {
        return this.handshaking;
    }

    public String getLocalFingerprint() {
        if (this.localFingerprint == null || this.localFingerprint.isEmpty()) {
            this.localFingerprint = this.server.generateFingerprint(this.localHashFunction);
        }
        return this.localFingerprint;
    }

    public void resetLocalFingerprint() {
        this.localFingerprint = "";
    }

    public String getLocalHashFunction() {
        return this.localHashFunction;
    }

    public String getRemoteHashFunction() {
        return this.remoteHashFunction;
    }

    public String getRemoteFingerprintValue() {
        return this.remoteFingerprint;
    }

    public String getRemoteFingerprint() {
        return this.remoteHashFunction + " " + this.remoteFingerprint;
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.remoteHashFunction = hashFunction;
        this.remoteFingerprint = fingerprint;
    }

    private byte[] getMasterServerKey() {
        return this.server.getSrtpMasterServerKey();
    }

    private byte[] getMasterServerSalt() {
        return this.server.getSrtpMasterServerSalt();
    }

    private byte[] getMasterClientKey() {
        return this.server.getSrtpMasterClientKey();
    }

    private byte[] getMasterClientSalt() {
        return this.server.getSrtpMasterClientSalt();
    }

    private SRTPPolicy getSrtpPolicy() {
        return this.server.getSrtpPolicy();
    }

    private SRTPPolicy getSrtcpPolicy() {
        return this.server.getSrtcpPolicy();
    }

    public PacketTransformer getSrtpDecoder() {
        return this.srtpDecoder;
    }

    public PacketTransformer getSrtpEncoder() {
        return this.srtpEncoder;
    }

    public PacketTransformer getSrtcpDecoder() {
        return this.srtcpDecoder;
    }

    public PacketTransformer getSrtcpEncoder() {
        return this.srtcpEncoder;
    }

    private PacketTransformer generateRtpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtcpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    private PacketTransformer generateRtcpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    public byte[] decodeRTP(byte[] packet, int offset, int length) {
        return this.srtpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTP(byte[] packet, int offset, int length) {
        return this.srtpEncoder.transform(packet, offset, length);
    }

    public byte[] decodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpEncoder.transform(packet, offset, length);
    }

    public void handshake() {
        if (!this.handshaking && !this.handshakeComplete) {
            this.handshaking = true;
            this.startTime = System.currentTimeMillis();
            this.worker = new Thread((Runnable)new HandshakeWorker(), "DTLS-Server-" + THREAD_COUNTER.incrementAndGet());
            this.worker.start();
        }
    }

    private void fireHandshakeComplete() {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeComplete();
            }
        }
    }

    private void fireHandshakeFailed(Throwable e) {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeFailed(e);
            }
        }
    }

    public void reset() {
        this.server = new DtlsSrtpServer();
        this.channel = null;
        this.srtcpDecoder = null;
        this.srtcpEncoder = null;
        this.srtpDecoder = null;
        this.srtpEncoder = null;
        this.remoteHashFunction = "";
        this.remoteFingerprint = "";
        this.localFingerprint = "";
        this.handshakeComplete = false;
        this.handshakeFailed = false;
        this.handshaking = false;
        this.startTime = 0L;
        this.listeners.clear();
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int contentType = packet[offset] & 0xFF;
        return contentType > 19 && contentType < 64;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        this.rxQueue.offer(ByteBuffer.wrap(packet, offset, dataLength));
        return null;
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    public int getReceiveLimit() throws IOException {
        return this.receiveLimit;
    }

    public int getSendLimit() throws IOException {
        return this.sendLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        if (this.hasTimeout()) {
            this.close();
            throw new IllegalStateException("Handshake is taking too long! (>10000ms");
        }
        int attempts = 20;
        do {
            ByteBuffer data;
            if ((data = this.rxQueue.poll()) != null) {
                data.get(buf, off, data.limit());
                return data.limit();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Could not sleep thread to receive DTLS data.");
            }
            finally {
                --attempts;
            }
        } while (attempts > 0);
        throw new SocketTimeoutException("Could not receive DTLS packet in " + waitMillis);
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        if (!this.hasTimeout()) {
            if (this.channel != null && this.channel.isOpen() && this.channel.isConnected()) {
                this.channel.send(ByteBuffer.wrap(buf, off, len), this.channel.getRemoteAddress());
            } else {
                logger.warn((Object)"Handler skipped send operation because channel is not open or connected.");
            }
        } else {
            logger.warn((Object)"Handler has timed out so send operation will be skipped.");
        }
    }

    public void close() throws IOException {
        this.rxQueue.clear();
        this.startTime = 0L;
        this.channel = null;
    }

    private boolean hasTimeout() {
        return System.currentTimeMillis() - this.startTime > 10000L;
    }

    private class HandshakeWorker
    implements Runnable {
        private HandshakeWorker() {
        }

        @Override
        public void run() {
            SecureRandom secureRandom = new SecureRandom();
            DTLSServerProtocol serverProtocol = new DTLSServerProtocol(secureRandom);
            try {
                serverProtocol.accept((TlsServer)DtlsHandler.this.server, (DatagramTransport)DtlsHandler.this);
                DtlsHandler.this.server.prepareSrtpSharedSecret();
                DtlsHandler.this.srtpDecoder = DtlsHandler.this.generateRtpDecoder();
                DtlsHandler.this.srtpEncoder = DtlsHandler.this.generateRtpEncoder();
                DtlsHandler.this.srtcpDecoder = DtlsHandler.this.generateRtcpDecoder();
                DtlsHandler.this.srtcpEncoder = DtlsHandler.this.generateRtcpEncoder();
                DtlsHandler.this.handshakeComplete = true;
                DtlsHandler.this.handshakeFailed = false;
                DtlsHandler.this.handshaking = false;
                DtlsHandler.this.fireHandshakeComplete();
            }
            catch (Exception e) {
                logger.error((Object)"DTLS handshake failed. Reason:", (Throwable)e);
                DtlsHandler.this.handshakeComplete = false;
                DtlsHandler.this.handshakeFailed = true;
                DtlsHandler.this.handshaking = false;
                DtlsHandler.this.fireHandshakeFailed(e);
            }
        }
    }
}

