/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpIntervalCalculator;
import org.mobicents.media.server.impl.rtcp.RtcpPacket;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.impl.rtcp.RtcpReport;
import org.mobicents.media.server.impl.rtcp.RtcpReportBlock;
import org.mobicents.media.server.impl.rtcp.RtcpSdes;
import org.mobicents.media.server.impl.rtcp.RtcpSenderReport;
import org.mobicents.media.server.impl.rtp.CnameGenerator;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.SsrcGenerator;
import org.mobicents.media.server.impl.rtp.statistics.RtpMember;
import org.mobicents.media.server.scheduler.Clock;

public class RtpStatistics {
    private static final Logger logger = Logger.getLogger(RtpStatistics.class);
    public static final int RTP_DEFAULT_BW = 8000;
    public static final double RTCP_BW_FRACTION = 0.05;
    public static final double RTCP_DEFAULT_BW = 400.0;
    public static final double RTCP_SENDER_BW_FRACTION = 0.25;
    public static final double RTCP_RECEIVER_BW_FRACTION = 0.75;
    public static final double RTCP_DEFAULT_AVG_SIZE = 200.0;
    private final RtpClock rtpClock;
    private final Clock wallClock;
    private long ssrc;
    private String cname;
    private long rtpLastHeartbeat;
    private volatile long rtpRxPackets;
    private volatile long rtpRxOctets;
    private volatile long rtpTxPackets;
    private volatile long rtpTxOctets;
    private volatile long rtpReceivedOn;
    private volatile long rtpSentOn;
    private volatile long rtpTimestamp;
    private RtcpPacketType rtcpNextPacketType;
    private double rtcpBw;
    private double rtcpAvgSize;
    private boolean weSent;
    private volatile long rtcpTxPackets;
    private volatile long rtcpTxOctets;
    private final Map<Long, RtpMember> membersMap;
    private int pmembers;
    private int members;
    private final List<Long> sendersList;
    private int senders;

    public RtpStatistics(RtpClock clock, long ssrc, String cname) {
        this.rtpClock = clock;
        this.wallClock = clock.getWallClock();
        this.ssrc = ssrc;
        this.cname = cname;
        this.rtpLastHeartbeat = 0L;
        this.rtpRxPackets = 0L;
        this.rtpRxOctets = 0L;
        this.rtpTxPackets = 0L;
        this.rtpTxOctets = 0L;
        this.rtpReceivedOn = 0L;
        this.rtpSentOn = 0L;
        this.rtpTimestamp = -1L;
        this.senders = 0;
        this.sendersList = new ArrayList<Long>();
        this.pmembers = 1;
        this.members = 1;
        this.membersMap = new HashMap<Long, RtpMember>();
        this.membersMap.put(this.ssrc, new RtpMember(this.rtpClock, this.ssrc));
        this.rtcpBw = 400.0;
        this.rtcpAvgSize = 200.0;
        this.rtcpNextPacketType = RtcpPacketType.RTCP_REPORT;
        this.weSent = false;
        this.rtcpTxPackets = 0L;
        this.rtcpTxOctets = 0L;
    }

    public RtpStatistics(RtpClock clock, long ssrc) {
        this(clock, ssrc, "");
    }

    public RtpStatistics(RtpClock clock) {
        this(clock, SsrcGenerator.generateSsrc(), CnameGenerator.generateCname());
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    public long getLastHeartbeat() {
        return this.rtpLastHeartbeat;
    }

    public void setLastHeartbeat(long rtpKeepAlive) {
        this.rtpLastHeartbeat = rtpKeepAlive;
    }

    public long getTime() {
        return this.wallClock.getTime();
    }

    public long getCurrentTime() {
        return this.wallClock.getCurrentTime();
    }

    public long getRtpTime(long time) {
        return this.rtpClock.convertToRtpTime(time);
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public String getCname() {
        return this.cname;
    }

    public long getRtpPacketsReceived() {
        return this.rtpRxPackets;
    }

    public long getRtpOctetsReceived() {
        return this.rtpRxOctets;
    }

    public long getRtpPacketsSent() {
        return this.rtpTxPackets;
    }

    public long getRtpOctetsSent() {
        return this.rtpTxOctets;
    }

    public long getRtpReceivedOn() {
        return this.rtpReceivedOn;
    }

    public long getRtpSentOn() {
        return this.rtpSentOn;
    }

    public long getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public boolean hasSent() {
        return this.weSent;
    }

    public double getRtcpBw() {
        return this.rtcpBw;
    }

    public RtcpPacketType getRtcpPacketType() {
        return this.rtcpNextPacketType;
    }

    public void setRtcpPacketType(RtcpPacketType packetType) {
        this.rtcpNextPacketType = packetType;
    }

    public int getSenders() {
        return this.senders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSender(long ssrc) {
        List<Long> list = this.sendersList;
        synchronized (list) {
            return this.sendersList.contains(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSender(long ssrc) {
        List<Long> list = this.sendersList;
        synchronized (list) {
            if (!this.sendersList.contains(ssrc)) {
                this.sendersList.add(ssrc);
                ++this.senders;
                if (this.ssrc == ssrc) {
                    this.weSent = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSender(long ssrc) {
        List<Long> list = this.sendersList;
        synchronized (list) {
            if (this.sendersList.remove(ssrc)) {
                --this.senders;
                if (this.ssrc == ssrc) {
                    this.weSent = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSenders() {
        List<Long> list = this.sendersList;
        synchronized (list) {
            this.sendersList.clear();
            this.senders = 0;
            this.weSent = false;
        }
    }

    public int getPmembers() {
        return this.pmembers;
    }

    public int getMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpMember getMember(long ssrc) {
        Map<Long, RtpMember> map = this.membersMap;
        synchronized (map) {
            return this.membersMap.get(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getMembersList() {
        ArrayList<Long> copy;
        Map<Long, RtpMember> map = this.membersMap;
        synchronized (map) {
            copy = new ArrayList<Long>(this.membersMap.keySet());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(long ssrc) {
        Map<Long, RtpMember> map = this.membersMap;
        synchronized (map) {
            return this.membersMap.containsKey(ssrc);
        }
    }

    private RtpMember addMember(long ssrc) {
        return this.addMember(ssrc, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RtpMember addMember(long ssrc, String cname) {
        RtpMember member = this.getMember(ssrc);
        if (member == null) {
            Map<Long, RtpMember> map = this.membersMap;
            synchronized (map) {
                member = new RtpMember(this.rtpClock, ssrc, cname);
                this.membersMap.put(ssrc, member);
                ++this.members;
            }
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(long ssrc) {
        Map<Long, RtpMember> map = this.membersMap;
        synchronized (map) {
            if (this.membersMap.remove(ssrc) != null) {
                --this.members;
            }
        }
    }

    public void confirmMembers() {
        this.pmembers = this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMembers() {
        Map<Long, RtpMember> map = this.membersMap;
        synchronized (map) {
            this.membersMap.clear();
            this.membersMap.put(this.ssrc, new RtpMember(this.rtpClock, this.ssrc));
            this.members = 1;
            this.pmembers = 1;
        }
    }

    public double getRtcpAvgSize() {
        return this.rtcpAvgSize;
    }

    public void setRtcpAvgSize(double avgSize) {
        this.rtcpAvgSize = avgSize;
    }

    private double calculateAvgRtcpSize(double packetSize) {
        this.rtcpAvgSize = 0.0625 * packetSize + 0.9375 * this.rtcpAvgSize;
        return this.rtcpAvgSize;
    }

    public long getRtcpPacketsSent() {
        return this.rtcpTxPackets;
    }

    public long getRtcpOctetsSent() {
        return this.rtcpTxOctets;
    }

    public long rtcpInterval(boolean initial) {
        return RtcpIntervalCalculator.calculateInterval(initial, this.weSent, this.senders, this.members, this.rtcpAvgSize, this.rtcpBw, 0.05, 0.25, 0.75);
    }

    public long rtcpReceiverInterval(boolean initial) {
        return RtcpIntervalCalculator.calculateInterval(initial, false, this.senders, this.members, this.rtcpAvgSize, this.rtcpBw, 0.05, 0.25, 0.75);
    }

    public boolean isSenderTimeout() {
        long t = this.rtcpReceiverInterval(false);
        long minTime = this.getCurrentTime() - 2L * t;
        if (this.rtpSentOn < minTime) {
            this.removeSender(this.ssrc);
        }
        return this.weSent;
    }

    public void reset() {
        this.ssrc = SsrcGenerator.generateSsrc();
        this.cname = CnameGenerator.generateCname();
        this.rtpLastHeartbeat = 0L;
        this.rtpRxPackets = 0L;
        this.rtpTxPackets = 0L;
        this.rtpReceivedOn = 0L;
        this.rtpSentOn = 0L;
        this.rtpTimestamp = -1L;
        this.senders = 0;
        this.sendersList.clear();
        this.pmembers = 1;
        this.members = 1;
        this.membersMap.clear();
        this.membersMap.put(this.ssrc, new RtpMember(this.rtpClock, this.ssrc));
        this.rtcpBw = 400.0;
        this.rtcpAvgSize = 200.0;
        this.rtcpNextPacketType = RtcpPacketType.RTCP_REPORT;
        this.weSent = false;
    }

    public void onRtpSent(RtpPacket packet) {
        ++this.rtpTxPackets;
        this.rtpTxOctets += (long)packet.getPayloadLength();
        this.rtpSentOn = this.wallClock.getCurrentTime();
        this.rtpTimestamp = packet.getTimestamp();
        if (!this.weSent) {
            this.addSender(this.ssrc);
        }
    }

    public void onRtpReceive(RtpPacket packet) {
        ++this.rtpRxPackets;
        this.rtpRxOctets += (long)packet.getPayloadLength();
        this.rtpReceivedOn = this.wallClock.getTime();
        if (RtcpPacketType.RTCP_REPORT.equals((Object)this.rtcpNextPacketType)) {
            long syncSource = packet.getSyncSource();
            RtpMember member = this.getMember(syncSource);
            if (member == null) {
                member = this.addMember(syncSource);
            }
            if (!this.isSender(syncSource)) {
                this.addSender(syncSource);
            }
            member.onReceiveRtp(packet);
        }
    }

    public void onRtcpSent(RtcpPacket packet) {
        this.calculateAvgRtcpSize(packet.getSize());
        ++this.rtcpTxPackets;
        this.rtcpTxOctets += (long)packet.getSize();
    }

    public void onRtcpReceive(RtcpPacket rtcpPacket) {
        RtcpReport report = rtcpPacket.getReport();
        long ssrc = report.getSsrc();
        block0 : switch (rtcpPacket.getPacketType()) {
            case RTCP_REPORT: {
                RtpMember member = this.getMember(ssrc);
                if (member == null && RtcpPacketType.RTCP_REPORT.equals((Object)this.rtcpNextPacketType)) {
                    RtcpSdes sdes = rtcpPacket.getSdes();
                    String cname = sdes == null ? "" : sdes.getCname();
                    member = this.addMember(ssrc, cname);
                }
                if (!rtcpPacket.isSender() || member == null) break;
                member.onReceiveSR((RtcpSenderReport)report);
                RtcpReportBlock reportBlock = report.getReportBlock(this.ssrc);
                if (reportBlock == null) break;
                member.estimateRtt(this.wallClock.getCurrentTime(), reportBlock.getLsr(), reportBlock.getDlsr());
                break;
            }
            case RTCP_BYE: {
                switch (this.rtcpNextPacketType) {
                    case RTCP_REPORT: {
                        if (this.isMember(ssrc)) {
                            this.removeMember(ssrc);
                        }
                        if (!this.isSender(ssrc)) break block0;
                        this.removeSender(ssrc);
                        break;
                    }
                    case RTCP_BYE: {
                        ++this.members;
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unknown type of scheduled event: " + this.rtcpNextPacketType.name()));
                        break;
                    }
                }
                break;
            }
            default: {
                logger.warn((Object)("Unkown RTCP packet type: " + rtcpPacket.getPacketType().name() + ". Dropping packet."));
            }
        }
        this.calculateAvgRtcpSize(rtcpPacket.getSize());
    }
}

