/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.UseSRTPData;
import org.mobicents.media.server.impl.rtp.crypto.SRTPParameters;
import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;
import org.mobicents.media.server.impl.rtp.crypto.TlsUtils;

public class DtlsSrtpServer
extends DefaultTlsServer {
    private static final Logger LOGGER = Logger.getLogger(DtlsSrtpServer.class);
    private static final String[] CERT_RESOURCES = new String[]{"x509-server.pem", "x509-ca.pem"};
    private static final String KEY_RESOURCE = "x509-server-key.pem";
    private String hashFunction = "";
    private UseSRTPData serverSrtpData;
    private byte[] srtpMasterClientKey;
    private byte[] srtpMasterServerKey;
    private byte[] srtpMasterClientSalt;
    private byte[] srtpMasterServerSalt;
    private SRTPPolicy srtpPolicy;
    private SRTPPolicy srtcpPolicy;

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        Level logLevel = alertLevel == 2 ? Level.ERROR : Level.WARN;
        LOGGER.log((Priority)logLevel, (Object)String.format("DTLS server raised alert (AlertLevel.%d, AlertDescription.%d, message='%s')", alertLevel, alertDescription, message), (Throwable)cause);
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level logLevel = alertLevel == 2 ? Level.ERROR : Level.WARN;
        LOGGER.log((Priority)logLevel, (Object)String.format("DTLS server received alert (AlertLevel.%d, AlertDescription.%d)", alertLevel, alertDescription));
    }

    public CertificateRequest getCertificateRequest() {
        Vector<SignatureAndHashAlgorithm> serverSigAlgs = null;
        if (org.bouncycastle.crypto.tls.TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.serverVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1, 3};
            serverSigAlgs = new Vector<SignatureAndHashAlgorithm>();
            for (int i = 0; i < hashAlgorithms.length; ++i) {
                for (int j = 0; j < signatureAlgorithms.length; ++j) {
                    serverSigAlgs.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                }
            }
        }
        return new CertificateRequest(new short[]{1}, serverSigAlgs, null);
    }

    public void notifyClientCertificate(org.bouncycastle.crypto.tls.Certificate clientCertificate) throws IOException {
        Certificate[] chain = clientCertificate.getCertificateList();
        LOGGER.info((Object)String.format("Received client certificate chain of length %d", chain.length));
        for (int i = 0; i != chain.length; ++i) {
            Certificate entry = chain[i];
            LOGGER.info((Object)String.format("WebRTC Client certificate fingerprint:%s (%s)", TlsUtils.fingerprint(this.hashFunction, entry), entry.getSubject()));
        }
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.DTLSv12;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        return TlsUtils.loadEncryptionCredentials((TlsContext)this.context, CERT_RESOURCES, KEY_RESOURCE);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        if (sigAlgs != null) {
            for (int i = 0; i < sigAlgs.size(); ++i) {
                SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                if (sigAlg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = sigAlg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        return TlsUtils.loadSignerCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, KEY_RESOURCE, signatureAndHashAlgorithm);
    }

    public Hashtable<Integer, byte[]> getServerExtensions() throws IOException {
        Hashtable serverExtensions = super.getServerExtensions();
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions) == null) {
            if (serverExtensions == null) {
                serverExtensions = new Hashtable();
            }
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, (UseSRTPData)this.serverSrtpData);
        }
        return serverExtensions;
    }

    public void processClientExtensions(Hashtable newClientExtensions) throws IOException {
        super.processClientExtensions(newClientExtensions);
        int chosenProfile = 1;
        UseSRTPData clientSrtpData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)newClientExtensions);
        block3: for (int profile : clientSrtpData.getProtectionProfiles()) {
            switch (profile) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    chosenProfile = profile;
                    continue block3;
                }
            }
        }
        int[] protectionProfiles = new int[]{chosenProfile};
        this.serverSrtpData = new UseSRTPData(protectionProfiles, clientSrtpData.getMki());
    }

    public byte[] getKeyingMaterial(int length) {
        return this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, length);
    }

    public void prepareSrtpSharedSecret() {
        SRTPParameters srtpParams = SRTPParameters.getSrtpParametersForProfile(this.serverSrtpData.getProtectionProfiles()[0]);
        int keyLen = srtpParams.getCipherKeyLength();
        int saltLen = srtpParams.getCipherSaltLength();
        this.srtpPolicy = srtpParams.getSrtpPolicy();
        this.srtcpPolicy = srtpParams.getSrtcpPolicy();
        this.srtpMasterClientKey = new byte[keyLen];
        this.srtpMasterServerKey = new byte[keyLen];
        this.srtpMasterClientSalt = new byte[saltLen];
        this.srtpMasterServerSalt = new byte[saltLen];
        byte[] sharedSecret = this.getKeyingMaterial(2 * (keyLen + saltLen));
        System.arraycopy(sharedSecret, 0, this.srtpMasterClientKey, 0, keyLen);
        System.arraycopy(sharedSecret, keyLen, this.srtpMasterServerKey, 0, keyLen);
        System.arraycopy(sharedSecret, 2 * keyLen, this.srtpMasterClientSalt, 0, saltLen);
        System.arraycopy(sharedSecret, 2 * keyLen + saltLen, this.srtpMasterServerSalt, 0, saltLen);
    }

    public SRTPPolicy getSrtpPolicy() {
        return this.srtpPolicy;
    }

    public SRTPPolicy getSrtcpPolicy() {
        return this.srtcpPolicy;
    }

    public byte[] getSrtpMasterServerKey() {
        return this.srtpMasterServerKey;
    }

    public byte[] getSrtpMasterServerSalt() {
        return this.srtpMasterServerSalt;
    }

    public byte[] getSrtpMasterClientKey() {
        return this.srtpMasterClientKey;
    }

    public byte[] getSrtpMasterClientSalt() {
        return this.srtpMasterClientSalt;
    }

    public String generateFingerprint(String hashFunction) {
        try {
            this.hashFunction = hashFunction;
            org.bouncycastle.crypto.tls.Certificate chain = TlsUtils.loadCertificateChain(CERT_RESOURCES);
            Certificate certificate = chain.getCertificateAt(0);
            return TlsUtils.fingerprint(this.hashFunction, certificate);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Could not get local fingerprint: " + e.getMessage()));
            return "";
        }
    }
}

