/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.tls.DatagramTransport;

public class DatagramTransportAdaptor
implements DatagramTransport {
    private static final int MIN_IP_OVERHEAD = 20;
    private static final int MAX_IP_OVERHEAD = 84;
    private static final int UDP_OVERHEAD = 8;
    private int receiveLimit;
    private int sendLimit;
    private ByteBuffer inputBuffer;
    private ByteBuffer outputBuffer;

    public void setInputBuffer(ByteBuffer newBuffer) {
        this.inputBuffer = newBuffer;
        this.receiveLimit = this.inputBuffer.capacity() - 20 - 8;
        this.inputBuffer.flip();
    }

    public void setOutputBuffer(ByteBuffer newBuffer) {
        this.outputBuffer = newBuffer;
        this.sendLimit = this.outputBuffer.capacity() - 84 - 8;
        this.outputBuffer.clear();
    }

    public int getReceiveLimit() {
        return this.receiveLimit;
    }

    public int getSendLimit() {
        return this.sendLimit;
    }

    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        int remaining = this.inputBuffer.remaining();
        if (len < remaining) {
            throw new BufferOverflowException();
        }
        this.inputBuffer.get(buf, off, remaining);
        return remaining;
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        if (len > this.getSendLimit()) {
            throw new BufferOverflowException();
        }
        this.outputBuffer.put(buf, off, len);
    }

    public void close() throws IOException {
    }
}

