/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.SRTCPTransformer;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformer;
import org.mobicents.media.server.impl.rtp.crypto.TransformEngine;

public class AsymmetricSRTPTransformer
implements TransformEngine {
    private SRTPTransformEngine forwardEngine;
    private SRTPTransformEngine reverseEngine;

    public AsymmetricSRTPTransformer(SRTPTransformEngine forwardEngine, SRTPTransformEngine reverseEngine) {
        this.forwardEngine = forwardEngine;
        this.reverseEngine = reverseEngine;
    }

    public void close() {
        if (this.forwardEngine != null) {
            this.forwardEngine.close();
        }
        if (this.reverseEngine != null) {
            this.reverseEngine.close();
        }
        this.forwardEngine = null;
        this.reverseEngine = null;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return new SRTCPTransformer(this.forwardEngine, this.reverseEngine);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return new SRTPTransformer(this.forwardEngine, this.reverseEngine);
    }
}

