/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.channels;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceAuthenticatorImpl;
import org.mobicents.media.server.impl.rtcp.RtcpChannel;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.RtpChannel;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.SsrcGenerator;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.format.AVProfile;
import org.mobicents.media.server.io.sdp.format.RTPFormat;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.utils.Text;

public abstract class MediaChannel {
    private static final Logger logger = Logger.getLogger(MediaChannel.class);
    private static final AudioFormat DTMF_FORMAT = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private static final AudioFormat LINEAR_FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    protected final String mediaType;
    protected long ssrc;
    protected String cname;
    protected boolean rtcpMux;
    protected boolean open;
    private boolean ice;
    private boolean dtls;
    protected RtpClock clock;
    protected RtpClock oobClock;
    protected RtpChannel rtpChannel;
    protected RtcpChannel rtcpChannel;
    protected RtpStatistics statistics;
    protected RTPFormats supportedFormats;
    protected RTPFormats offeredFormats;
    protected RTPFormats negotiatedFormats;
    protected boolean negotiated;
    private final IceAuthenticatorImpl iceAuthenticator;

    protected MediaChannel(String mediaType, Clock wallClock, ChannelsManager channelsManager) {
        this.mediaType = mediaType;
        this.ssrc = 0L;
        this.cname = "";
        this.rtcpMux = false;
        this.open = false;
        this.ice = false;
        this.dtls = false;
        this.clock = new RtpClock(wallClock);
        this.oobClock = new RtpClock(wallClock);
        this.statistics = new RtpStatistics(this.clock, this.ssrc);
        this.rtpChannel = channelsManager.getRtpChannel(this.statistics, this.clock, this.oobClock);
        this.rtcpChannel = channelsManager.getRtcpChannel(this.statistics);
        this.offeredFormats = new RTPFormats();
        this.negotiatedFormats = new RTPFormats();
        this.negotiated = false;
        this.iceAuthenticator = new IceAuthenticatorImpl();
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public String getCname() {
        return this.cname;
    }

    public void setCname(String cname) {
        this.cname = cname;
        this.statistics.setCname(cname);
    }

    public String getExternalAddress() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getExternalAddress();
        }
        return "";
    }

    public String getRtpAddress() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalHost();
        }
        return "";
    }

    public int getRtpPort() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalPort();
        }
        return 0;
    }

    public String getRtcpAddress() {
        if (this.rtcpMux) {
            return this.getRtpAddress();
        }
        if (this.rtcpChannel.isBound()) {
            return this.rtcpChannel.getLocalHost();
        }
        return "";
    }

    public int getRtcpPort() {
        if (this.rtcpMux) {
            return this.getRtpPort();
        }
        if (this.rtcpChannel.isBound()) {
            return this.rtcpChannel.getLocalPort();
        }
        return 0;
    }

    public void open() {
        this.ssrc = SsrcGenerator.generateSsrc();
        this.statistics.setSsrc(this.ssrc);
        this.open = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is open"));
        }
    }

    public void close() throws IllegalStateException {
        if (this.open) {
            this.rtpChannel.close();
            if (!this.rtcpMux) {
                this.rtcpChannel.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is closed"));
            }
        } else {
            throw new IllegalStateException("Channel is already inactive");
        }
        this.reset();
        this.open = false;
    }

    private void reset() {
        this.resetFormats();
        if (this.rtcpMux) {
            this.rtcpMux = false;
        }
        if (this.ice) {
            this.disableICE();
        }
        if (this.dtls) {
            this.disableDTLS();
        }
        this.statistics.reset();
        this.cname = "";
        this.ssrc = 0L;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isAvailable() {
        boolean available = this.rtpChannel.isAvailable();
        if (!this.rtcpMux) {
            available = available && this.rtcpChannel.isAvailable();
        }
        return available;
    }

    public void setInputDsp(Processor dsp) {
        this.rtpChannel.setInputDsp(dsp);
    }

    public Processor getInputDsp() {
        return this.rtpChannel.getInputDsp();
    }

    public void setOutputDsp(Processor dsp) {
        this.rtpChannel.setOutputDsp(dsp);
    }

    public Processor getOutputDsp() {
        return this.rtpChannel.getOutputDsp();
    }

    public void setConnectionMode(ConnectionMode mode) {
        this.rtpChannel.updateMode(mode);
    }

    protected void setFormats(RTPFormats formats) {
        try {
            this.rtpChannel.setFormatMap(formats);
            this.rtpChannel.setOutputFormats(formats.getFormats());
        }
        catch (FormatNotSupportedException e) {
            logger.warn((Object)"Could not set output formats", (Throwable)e);
        }
    }

    public RTPFormats getFormats() {
        if (this.negotiated) {
            return this.negotiatedFormats;
        }
        return this.supportedFormats;
    }

    public RTPFormats getFormatMap() {
        return this.rtpChannel.getFormatMap();
    }

    public void bind(boolean isLocal, boolean rtcpMux) throws IOException, IllegalStateException {
        this.rtpChannel.bind(isLocal, rtcpMux);
        if (!rtcpMux) {
            this.rtcpChannel.bind(isLocal, this.rtpChannel.getLocalPort() + 1);
        }
        this.rtcpMux = rtcpMux;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " is bound to " + this.rtpChannel.getLocalHost() + ":" + this.rtpChannel.getLocalPort()));
            if (rtcpMux) {
                logger.debug((Object)(this.mediaType + " is multiplexing RTCP"));
            } else {
                logger.debug((Object)(this.mediaType + " RTCP channel " + this.ssrc + " is bound to " + this.rtcpChannel.getLocalHost() + ":" + this.rtcpChannel.getLocalPort()));
            }
        }
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    public void connectRtp(SocketAddress address) {
        this.rtpChannel.setRemotePeer(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " connected to remote peer " + address.toString()));
        }
    }

    public void connectRtp(String address, int port) {
        this.connectRtp(new InetSocketAddress(address, port));
    }

    public void bindRtcp(boolean isLocal, int port) throws IOException, IllegalStateException {
        if (this.ice) {
            throw new IllegalStateException("Cannot bind when ICE is enabled");
        }
        this.rtcpChannel.bind(isLocal, port);
        this.rtcpMux = port == this.rtpChannel.getLocalPort();
    }

    public void connectRtcp(SocketAddress remoteAddress) {
        this.rtcpChannel.setRemotePeer(remoteAddress);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTCP channel " + this.ssrc + " has connected to remote peer " + remoteAddress.toString()));
        }
    }

    public void connectRtcp(String address, int port) {
        this.connectRtcp(new InetSocketAddress(address, port));
    }

    protected RTPFormats buildRTPMap(RTPFormats profile) {
        RTPFormats list = new RTPFormats();
        Formats fmts = new Formats();
        if (this.rtpChannel.getOutputDsp() != null) {
            Codec[] currCodecs = this.rtpChannel.getOutputDsp().getCodecs();
            for (int i = 0; i < currCodecs.length; ++i) {
                if (!currCodecs[i].getSupportedInputFormat().matches((Format)LINEAR_FORMAT)) continue;
                fmts.add(currCodecs[i].getSupportedOutputFormat());
            }
        }
        fmts.add((Format)DTMF_FORMAT);
        if (fmts != null) {
            for (int i = 0; i < fmts.size(); ++i) {
                RTPFormat f = profile.find(fmts.get(i));
                if (f == null) continue;
                list.add(f.clone());
            }
        }
        return list;
    }

    private void resetFormats() {
        this.offeredFormats.clean();
        this.negotiatedFormats.clean();
        this.setFormats(this.supportedFormats);
        this.negotiated = false;
    }

    public RTPFormats getNegotiatedFormats() {
        return this.negotiatedFormats;
    }

    public boolean hasNegotiatedFormats() {
        return this.negotiated;
    }

    public void negotiateFormats(MediaDescriptionField media) {
        this.offeredFormats.clean();
        for (int payloadType : media.getPayloadTypes()) {
            RTPFormat format = AVProfile.getFormat((int)payloadType, (Text)AVProfile.AUDIO);
            if (format == null) continue;
            this.offeredFormats.add(format);
        }
        this.negotiatedFormats.clean();
        this.supportedFormats.intersection(this.offeredFormats, this.negotiatedFormats);
        this.setFormats(this.negotiatedFormats);
        this.negotiated = true;
    }

    public boolean containsNegotiatedFormats() {
        return !this.negotiatedFormats.isEmpty() && this.negotiatedFormats.hasNonDTMF();
    }

    public void enableICE(String externalAddress, boolean rtcpMux) {
        if (!this.ice) {
            this.ice = true;
            this.rtcpMux = rtcpMux;
            this.iceAuthenticator.generateIceCredentials();
            this.rtpChannel.enableIce((IceAuthenticator)this.iceAuthenticator);
            if (!rtcpMux) {
                this.rtcpChannel.enableIce((IceAuthenticator)this.iceAuthenticator);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled ICE"));
            }
        }
    }

    public void disableICE() {
        if (this.ice) {
            this.ice = false;
            this.iceAuthenticator.reset();
            this.rtpChannel.disableIce();
            if (!this.rtcpMux) {
                this.rtcpChannel.disableIce();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled ICE"));
            }
        }
    }

    public boolean isIceEnabled() {
        return this.ice;
    }

    public String getIceUfrag() {
        return this.ice ? this.iceAuthenticator.getUfrag() : "";
    }

    public String getIcePwd() {
        return this.ice ? this.iceAuthenticator.getPassword() : "";
    }

    public void enableDTLS(String hashFunction, String remoteFingerprint) {
        if (!this.dtls) {
            this.rtpChannel.enableSRTP(hashFunction, remoteFingerprint);
            if (!this.rtcpMux) {
                this.rtcpChannel.enableSRTCP(hashFunction, remoteFingerprint);
            }
            this.dtls = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled DTLS"));
            }
        }
    }

    public void enableDTLS() {
        if (!this.dtls) {
            this.rtpChannel.enableSRTP();
            if (!this.rtcpMux) {
                this.rtcpChannel.enableSRTCP();
            }
            this.dtls = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled DTLS"));
            }
        }
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        if (this.dtls) {
            this.rtpChannel.setRemoteFingerprint(hashFunction, fingerprint);
            if (!this.rtcpMux) {
                this.rtcpChannel.setRemoteFingerprint(hashFunction, fingerprint);
            }
        }
    }

    public void disableDTLS() {
        if (this.dtls) {
            this.rtpChannel.disableSRTP();
            if (!this.rtcpMux) {
                this.rtcpChannel.disableSRTCP();
            }
            this.dtls = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled DTLS"));
            }
        }
    }

    public boolean isDtlsEnabled() {
        return this.dtls;
    }

    public String getDtlsFingerprint() {
        if (this.dtls) {
            return this.rtpChannel.getWebRtcLocalFingerprint().toString();
        }
        return "";
    }

    public long getPacketsReceived() {
        if (this.open) {
            return this.statistics.getRtpPacketsReceived();
        }
        return 0L;
    }

    public long getOctetsReceived() {
        if (this.open) {
            return this.statistics.getRtpOctetsReceived();
        }
        return 0L;
    }

    public long getPacketsSent() {
        if (this.open) {
            return this.statistics.getRtpPacketsSent();
        }
        return 0L;
    }

    public long getOctetsSent() {
        if (this.open) {
            return this.statistics.getRtpOctetsSent();
        }
        return 0L;
    }

    public long getJitter() {
        if (this.open) {
            return this.statistics.getMember(this.ssrc).getJitter();
        }
        return 0L;
    }
}

