/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.util.UUID;

public class SsrcGenerator {
    public static final int MAX_SIZE = 32;

    public static long generateSsrc() {
        UUID uuid = UUID.randomUUID();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        byte[] data = SsrcGenerator.uIntLongToByteWord(leastSignificantBits);
        return SsrcGenerator.bytesToUIntLong(data, 0);
    }

    static long bytesToUIntLong(byte[] bytes, int index) {
        long accum = 0L;
        int i = 3;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum |= (long)(bytes[index + i] & 0xFF) << shiftBy;
            --i;
        }
        return accum;
    }

    static byte[] uIntLongToByteWord(long j) {
        int i = (int)j;
        byte[] byteWord = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return byteWord;
    }
}

