/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.JitterBuffer;
import org.mobicents.media.server.impl.rtp.RTPInput;
import org.mobicents.media.server.impl.rtp.RtpChannel;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.rfc2833.DtmfInput;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.io.sdp.format.RTPFormat;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;

public class RtpHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(RtpHandler.class);
    private int pipelinePriority = 0;
    private RTPFormats rtpFormats;
    private final RtpClock rtpClock;
    private final RtpClock oobClock;
    private JitterBuffer jitterBuffer;
    private int jitterBufferSize;
    private final RTPInput rtpInput;
    private final DtmfInput dtmfInput;
    private boolean loopable;
    private boolean receivable;
    private final RtpStatistics statistics;
    private final RtpPacket rtpPacket;
    private boolean secure;
    private DtlsHandler dtlsHandler;

    public RtpHandler(PriorityQueueScheduler scheduler, RtpClock clock, RtpClock oobClock, int jitterBufferSize, RtpStatistics statistics) {
        this.rtpClock = clock;
        this.oobClock = oobClock;
        this.jitterBufferSize = jitterBufferSize;
        this.jitterBuffer = new JitterBuffer(this.rtpClock, this.jitterBufferSize);
        this.rtpInput = new RTPInput(scheduler, this.jitterBuffer);
        this.jitterBuffer.setListener(this.rtpInput);
        this.dtmfInput = new DtmfInput(scheduler, oobClock);
        this.rtpFormats = new RTPFormats();
        this.statistics = statistics;
        this.rtpPacket = new RtpPacket(8192, true);
        this.receivable = false;
        this.loopable = false;
        this.secure = false;
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    public RTPInput getRtpInput() {
        return this.rtpInput;
    }

    public DtmfInput getDtmfInput() {
        return this.dtmfInput;
    }

    public boolean isLoopable() {
        return this.loopable;
    }

    public void setLoopable(boolean loopable) {
        this.loopable = loopable;
    }

    public boolean isReceivable() {
        return this.receivable;
    }

    public void setReceivable(boolean receivable) {
        this.receivable = receivable;
    }

    public void useJitterBuffer(boolean useBuffer) {
        this.jitterBuffer.setBufferInUse(useBuffer);
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.rtpFormats = rtpFormats;
        this.jitterBuffer.setFormats(rtpFormats);
    }

    public RTPFormats getFormatMap() {
        return this.rtpFormats;
    }

    public void enableSrtp(DtlsHandler handler) {
        this.secure = true;
        this.dtlsHandler = handler;
    }

    public void disableSrtp() {
        this.secure = false;
        this.dtlsHandler = null;
    }

    public void activate() {
        this.rtpInput.activate();
        this.dtmfInput.activate();
    }

    public void deactivate() {
        this.rtpInput.deactivate();
        this.dtmfInput.deactivate();
    }

    public void reset() {
        this.deactivate();
        this.dtmfInput.reset();
        if (this.secure) {
            this.disableSrtp();
        }
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int version;
        byte b0;
        int b0Int;
        if (dataLength >= 12 && (b0Int = (b0 = packet[offset]) & 0xFF) > 127 && b0Int < 192 && 2 == (version = (b0 & 0xC0) >> 6)) {
            int type = packet[offset + 1] & 0xFF & 0x7F;
            int rtcpType = type + 128;
            switch (rtcpType) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return null;
        }
        if (this.secure) {
            byte[] decoded = this.dtlsHandler.decodeRTP(packet, offset, dataLength);
            if (decoded == null || decoded.length == 0) {
                logger.warn((Object)"SRTP packet is not valid! Dropping packet.");
                return null;
            }
            ByteBuffer buffer = this.rtpPacket.getBuffer();
            buffer.clear();
            buffer.put(decoded);
            buffer.flip();
        } else {
            ByteBuffer buffer = this.rtpPacket.getBuffer();
            buffer.clear();
            buffer.put(packet, offset, dataLength);
            buffer.flip();
        }
        if (this.statistics.getRtpPacketsReceived() == 0L) {
            logger.info((Object)"Restarting jitter buffer");
            this.jitterBuffer.restart();
        }
        this.statistics.setLastHeartbeat(this.rtpClock.getWallClock().getTime());
        if (this.rtpPacket.getVersion() != 0 && (this.receivable || this.loopable)) {
            if (this.rtpPacket.getBuffer().limit() > 0) {
                if (this.loopable) {
                    this.statistics.onRtpReceive(this.rtpPacket);
                    this.statistics.onRtpSent(this.rtpPacket);
                    return packet;
                }
                this.statistics.onRtpReceive(this.rtpPacket);
                int payloadType = this.rtpPacket.getPayloadType();
                RTPFormat format = this.rtpFormats.find(payloadType);
                if (format != null) {
                    if (RtpChannel.DTMF_FORMAT.matches(format.getFormat())) {
                        this.dtmfInput.write(this.rtpPacket);
                    } else {
                        this.jitterBuffer.write(this.rtpPacket, format);
                    }
                } else {
                    logger.warn((Object)("Dropping packet because payload type (" + payloadType + ") is unknown."));
                }
            } else {
                logger.warn((Object)"Skipping packet because limit of the packets buffer is zero");
            }
        }
        return null;
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }
}

