/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.media.server.scheduler.Clock;

public class RtpClock {
    public static final Logger logger = Logger.getLogger(RtpClock.class);
    private Clock wallClock;
    private int clockRate;
    private int scale;
    protected long drift;
    private boolean isSynchronized;

    public RtpClock(Clock wallClock) {
        this.wallClock = wallClock;
    }

    public Clock getWallClock() {
        return this.wallClock;
    }

    public void setClockRate(int clockRate) {
        this.clockRate = clockRate;
        this.scale = clockRate / 1000;
    }

    public int getClockRate() {
        return this.clockRate;
    }

    public void synchronize(long remote) {
        this.drift = remote - this.getLocalRtpTime();
        this.isSynchronized = true;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void reset() {
        this.drift = 0L;
        this.clockRate = 0;
        this.isSynchronized = false;
    }

    public long getLocalRtpTime() {
        return (long)this.scale * this.wallClock.getTime(TimeUnit.MILLISECONDS) + this.drift;
    }

    public long convertToAbsoluteTime(long timestamp) {
        return timestamp * 1000L / (long)this.clockRate;
    }

    public long convertToRtpTime(long time) {
        return time * (long)this.clockRate / 1000L;
    }
}

