/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import org.apache.log4j.Logger;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.rtp.BufferListener;
import org.mobicents.media.server.impl.rtp.JitterBuffer;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;

public class RTPInput
extends AbstractSource
implements BufferListener {
    private static final long serialVersionUID = -737259897530641186L;
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private JitterBuffer rxBuffer;
    private Processor dsp;
    protected Integer preEvolveCount = 0;
    protected Integer evolveCount = 0;
    private static final Logger logger = Logger.getLogger(RTPInput.class);
    private AudioInput input;

    protected RTPInput(PriorityQueueScheduler scheduler, JitterBuffer rxBuffer) {
        super("rtpinput", scheduler, PriorityQueueScheduler.INPUT_QUEUE.intValue());
        this.rxBuffer = rxBuffer;
        this.input = new AudioInput(1, this.packetSize);
        this.connect((AbstractSink)this.input);
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public void reset() {
        super.reset();
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    protected int getPacketsLost() {
        return 0;
    }

    public Frame evolve(long timestamp) {
        Frame currFrame = this.rxBuffer.read(timestamp);
        if (currFrame != null && this.dsp != null) {
            try {
                currFrame = this.dsp.process(currFrame, currFrame.getFormat(), (Format)this.format);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return currFrame;
    }

    @Override
    public void onFill() {
        this.wakeup();
    }
}

