/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.impl.rtcp.RtcpChannel;
import org.mobicents.media.server.impl.rtp.LocalDataChannel;
import org.mobicents.media.server.impl.rtp.RTPDataChannel;
import org.mobicents.media.server.impl.rtp.RtpChannel;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.channels.AudioChannel;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.io.network.PortManager;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.ss7.SS7DataChannel;
import org.mobicents.media.server.io.ss7.SS7Manager;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.WallClock;

public class ChannelsManager {
    private UdpManager udpManager;
    private SS7Manager ss7Manager;
    private Clock clock = new WallClock();
    private boolean isControlEnabled = false;
    private PriorityQueueScheduler scheduler;
    private int jitterBufferSize = 50;
    private AtomicInteger channelIndex = new AtomicInteger(100);

    public ChannelsManager(UdpManager udpManager) {
        this.udpManager = udpManager;
    }

    public void setSS7Manager(SS7Manager ss7Manager) {
        this.ss7Manager = ss7Manager;
    }

    public SS7Manager getSS7Manager() {
        return this.ss7Manager;
    }

    public String getBindAddress() {
        return this.udpManager.getBindAddress();
    }

    public String getLocalBindAddress() {
        return this.udpManager.getLocalBindAddress();
    }

    public String getExternalAddress() {
        return this.udpManager.getExternalAddress();
    }

    public PortManager getPortManager() {
        return this.udpManager.getPortManager();
    }

    public void setScheduler(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public PriorityQueueScheduler getScheduler() {
        return this.scheduler;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Boolean getIsControlEnabled() {
        return this.isControlEnabled;
    }

    public int getJitterBufferSize() {
        return this.jitterBufferSize;
    }

    public void setJitterBufferSize(int jitterBufferSize) {
        this.jitterBufferSize = jitterBufferSize;
    }

    public UdpManager getUdpManager() {
        return this.udpManager;
    }

    @Deprecated
    public RTPDataChannel getChannel() {
        return new RTPDataChannel(this, this.channelIndex.incrementAndGet());
    }

    public RtpChannel getRtpChannel(RtpStatistics statistics, RtpClock clock, RtpClock oobClock) {
        return new RtpChannel(this.channelIndex.incrementAndGet(), this.jitterBufferSize, statistics, clock, oobClock, this.scheduler, this.udpManager);
    }

    public RtcpChannel getRtcpChannel(RtpStatistics statistics) {
        return new RtcpChannel(this.channelIndex.incrementAndGet(), statistics, this.udpManager);
    }

    public LocalDataChannel getLocalChannel() {
        return new LocalDataChannel(this, this.channelIndex.incrementAndGet());
    }

    public SS7DataChannel getSS7Channel(int dahdiChannelID, boolean isAlaw) throws IOException {
        if (this.ss7Manager == null) {
            throw new IOException("SS7 Not enabled");
        }
        return new SS7DataChannel(this.ss7Manager, dahdiChannelID, this.channelIndex.incrementAndGet(), isAlaw);
    }

    public AudioChannel getAudioChannel() {
        return new AudioChannel(this.scheduler.getClock(), this);
    }
}

