/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.Iterator;
import org.mobicents.media.server.impl.rtcp.RtcpReport;
import org.mobicents.media.server.impl.rtcp.RtcpReportBlock;
import org.mobicents.media.server.impl.rtcp.ntp.NtpUtils;

public class RtcpSenderReport
extends RtcpReport {
    private static final boolean IS_SENDER = true;
    private long ntpSec;
    private long ntpFrac;
    private long ntpTs;
    private long rtpTs;
    private long psent;
    private long osent;

    protected RtcpSenderReport() {
    }

    public RtcpSenderReport(boolean padding, long ssrc, long ntpSec, long ntpFrac, long rtpTs, long psent, long osent) {
        super(padding, ssrc, 200);
        this.ntpSec = ntpSec;
        this.ntpFrac = ntpFrac;
        this.ntpTs = NtpUtils.calculateLastSrTimestamp(ntpSec, ntpFrac);
        this.rtpTs = rtpTs;
        this.psent = psent;
        this.osent = osent;
    }

    @Override
    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpTs = NtpUtils.calculateLastSrTimestamp(this.ntpSec, this.ntpFrac);
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        int tmpCount = 0;
        while (offSet - tmp < this.length) {
            RtcpReportBlock rtcpReceptionReportItem = new RtcpReportBlock();
            offSet = rtcpReceptionReportItem.decode(rawData, offSet);
            this.addReceiverReport(rtcpReceptionReportItem);
            ++tmpCount;
        }
        return offSet;
    }

    @Override
    protected int encode(byte[] rawData, int offSet) {
        RtcpReportBlock report;
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ntpSec & 0xFFL);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ntpFrac & 0xFFL);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.rtpTs & 0xFFL);
        rawData[offSet++] = (byte)((this.psent & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.psent & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.psent & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.psent & 0xFFL);
        rawData[offSet++] = (byte)((this.osent & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.osent & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.osent & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.osent & 0xFFL);
        Iterator i$ = this.reportBlocks.iterator();
        while (i$.hasNext() && (report = (RtcpReportBlock)i$.next()) != null) {
            offSet = report.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public long getNtpSec() {
        return this.ntpSec;
    }

    public long getNtpFrac() {
        return this.ntpFrac;
    }

    public long getNtpTs() {
        return this.ntpTs;
    }

    public long getRtpTs() {
        return this.rtpTs;
    }

    public long getPsent() {
        return this.psent;
    }

    public long getOsent() {
        return this.osent;
    }

    @Override
    public boolean isSender() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SENDER REPORT:\n");
        builder.append("version=").append(this.version).append(", ");
        builder.append("padding=").append(this.padding).append(", ");
        builder.append("packet type=").append(this.packetType).append(", ");
        builder.append("length=").append(this.length).append(", ");
        builder.append("ssrc=").append(this.ssrc).append(", ");
        builder.append("ntp seconds=").append(this.ntpSec).append(", ");
        builder.append("ntp fraction=").append(this.ntpFrac).append(", ");
        builder.append("rtp timestamp=").append(this.rtpTs).append(", ");
        builder.append("packets sent=").append(this.psent).append(", ");
        builder.append("octets sent=").append(this.osent).append("\n");
        for (RtcpReportBlock rr : this.reportBlocks) {
            builder.append("\n").append(rr.toString());
        }
        return builder.toString();
    }
}

