/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.rtcp.RtcpHeader;
import org.mobicents.media.server.impl.rtcp.RtcpSdesChunk;

public class RtcpSdes
extends RtcpHeader {
    private final List<RtcpSdesChunk> sdesChunks = new ArrayList<RtcpSdesChunk>(31);

    protected RtcpSdes() {
    }

    public RtcpSdes(boolean padding) {
        super(padding, 202);
    }

    @Override
    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        while (offSet - tmp < this.length) {
            RtcpSdesChunk rtcpSdesChunk = new RtcpSdesChunk();
            offSet = rtcpSdesChunk.decode(rawData, offSet);
            this.sdesChunks.add(rtcpSdesChunk);
        }
        return offSet;
    }

    @Override
    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        for (RtcpSdesChunk rtcpSdesChunk : this.sdesChunks) {
            if (rtcpSdesChunk == null) break;
            offSet = rtcpSdesChunk.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public void addRtcpSdesChunk(RtcpSdesChunk rtcpSdesChunk) {
        if (this.count >= 31) {
            throw new ArrayIndexOutOfBoundsException("Reached maximum number of chunks: 31");
        }
        this.sdesChunks.add(rtcpSdesChunk);
        ++this.count;
    }

    public RtcpSdesChunk[] getSdesChunks() {
        RtcpSdesChunk[] chunks = new RtcpSdesChunk[this.sdesChunks.size()];
        return this.sdesChunks.toArray(chunks);
    }

    public String getCname() {
        for (RtcpSdesChunk chunk : this.sdesChunks) {
            String cname = chunk.getCname();
            if (cname == null || cname.isEmpty()) continue;
            return cname;
        }
        return "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SDES:\n");
        builder.append("version= ").append(this.version).append(", ");
        builder.append("padding= ").append(this.padding).append(", ");
        builder.append("source count= ").append(this.count).append(", ");
        builder.append("packet type= ").append(this.packetType).append(", ");
        builder.append("length= ").append(this.length).append(", ");
        for (RtcpSdesChunk chunk : this.sdesChunks) {
            builder.append("\n").append(chunk.toString());
        }
        return builder.toString();
    }
}

