/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.rtcp.RtcpHeader;
import org.mobicents.media.server.impl.rtcp.RtcpReportBlock;

public abstract class RtcpReport
extends RtcpHeader {
    protected long ssrc;
    protected List<RtcpReportBlock> reportBlocks;

    protected RtcpReport() {
        this.reportBlocks = new ArrayList<RtcpReportBlock>(31);
    }

    protected RtcpReport(boolean padding, long ssrc, int packetType) {
        super(padding, packetType);
        this.ssrc = ssrc;
        this.reportBlocks = new ArrayList<RtcpReportBlock>(31);
    }

    public abstract boolean isSender();

    public long getSsrc() {
        return this.ssrc;
    }

    public RtcpReportBlock[] getReportBlocks() {
        RtcpReportBlock[] blocks = new RtcpReportBlock[this.reportBlocks.size()];
        return this.reportBlocks.toArray(blocks);
    }

    public RtcpReportBlock getReportBlock(long ssrc) {
        for (RtcpReportBlock report : this.reportBlocks) {
            if (report.getSsrc() != ssrc) continue;
            return report;
        }
        return null;
    }

    public void addReceiverReport(RtcpReportBlock rtcpReceptionReportItem) {
        if (this.count >= 31) {
            throw new ArrayIndexOutOfBoundsException("Reached maximum number of items: 31");
        }
        this.reportBlocks.add(rtcpReceptionReportItem);
        ++this.count;
    }
}

