/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.Iterator;
import org.mobicents.media.server.impl.rtcp.RtcpReport;
import org.mobicents.media.server.impl.rtcp.RtcpReportBlock;

public class RtcpReceiverReport
extends RtcpReport {
    private static final boolean IS_SENDER = false;

    protected RtcpReceiverReport() {
    }

    public RtcpReceiverReport(boolean padding, long ssrc) {
        super(padding, ssrc, 201);
    }

    @Override
    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        int tmpCount = 0;
        while (offSet - tmp < this.length) {
            RtcpReportBlock rtcpReceptionReportItem = new RtcpReportBlock();
            offSet = rtcpReceptionReportItem.decode(rawData, offSet);
            this.reportBlocks.add(rtcpReceptionReportItem);
            ++tmpCount;
        }
        return offSet;
    }

    @Override
    protected int encode(byte[] rawData, int offSet) {
        RtcpReportBlock report;
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        Iterator i$ = this.reportBlocks.iterator();
        while (i$.hasNext() && (report = (RtcpReportBlock)i$.next()) != null) {
            offSet = report.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    @Override
    public boolean isSender() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RECEIVER REPORT: \n");
        builder.append("version=").append(this.version).append(", ");
        builder.append("padding=").append(this.padding).append(", ");
        builder.append("packet type=").append(this.packetType).append(", ");
        builder.append("length=").append(this.length).append(", ");
        builder.append("ssrc=").append(this.ssrc).append("\n");
        for (RtcpReportBlock rr : this.reportBlocks) {
            builder.append("\n").append(rr.toString());
        }
        return builder.toString();
    }
}

