/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpPacket;
import org.mobicents.media.server.impl.rtcp.RtcpPacketFactory;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.scheduler.Scheduler;

public class RtcpHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(RtcpHandler.class);
    private static final long SSRC_TASK_DELAY = 7000L;
    private DatagramChannel channel;
    private ByteBuffer byteBuffer;
    private int pipelinePriority;
    private final Scheduler scheduler;
    private TxTask scheduledTask;
    private Future<?> reportTaskFuture;
    private final SsrcTask ssrcTask;
    private Future<?> ssrcTaskFuture;
    private final RtpStatistics statistics;
    private long tp;
    private long tn;
    private AtomicBoolean initial;
    private AtomicBoolean joined;
    private boolean secure;
    private DtlsHandler dtlsHandler;

    public RtcpHandler(Scheduler scheduler, RtpStatistics statistics) {
        this.scheduler = scheduler;
        this.ssrcTask = new SsrcTask();
        this.pipelinePriority = 0;
        this.byteBuffer = ByteBuffer.allocateDirect(8192);
        this.statistics = statistics;
        this.scheduledTask = null;
        this.tp = 0L;
        this.tn = -1L;
        this.initial = new AtomicBoolean(true);
        this.joined = new AtomicBoolean(false);
        this.secure = false;
        this.dtlsHandler = null;
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    private long resolveInterval(long timestamp) {
        long interval = timestamp - this.statistics.getCurrentTime();
        return interval < 0L ? 0L : interval;
    }

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    public boolean isInitial() {
        return this.initial.get();
    }

    public boolean isJoined() {
        return this.joined.get();
    }

    public void joinRtpSession() {
        if (!this.joined.get()) {
            long t = this.statistics.rtcpInterval(this.initial.get());
            this.tn = this.statistics.getCurrentTime() + t;
            this.scheduleRtcp(this.tn, RtcpPacketType.RTCP_REPORT);
            this.ssrcTaskFuture = this.scheduler.scheduleWithFixedDelay((Runnable)this.ssrcTask, 7000L, 7000L, TimeUnit.MILLISECONDS);
            this.joined.set(true);
        }
    }

    public void leaveRtpSession() {
        if (this.joined.get()) {
            this.joined.set(false);
            this.tp = this.statistics.getCurrentTime();
            this.statistics.resetMembers();
            this.initial.set(true);
            this.statistics.clearSenders();
            if (this.reportTaskFuture != null) {
                this.reportTaskFuture.cancel(true);
            }
            this.statistics.setRtcpPacketType(RtcpPacketType.RTCP_BYE);
            this.scheduledTask = new TxTask(RtcpPacketType.RTCP_BYE);
            this.scheduledTask.run();
        }
    }

    public long getNextScheduledReport() {
        long delay = this.tn - this.statistics.getCurrentTime();
        return delay < 0L ? -1L : delay;
    }

    private void scheduleRtcp(long timestamp, RtcpPacketType packetType) {
        long interval = this.resolveInterval(timestamp);
        this.scheduledTask = new TxTask(packetType);
        try {
            this.reportTaskFuture = this.scheduler.schedule((Runnable)this.scheduledTask, interval, TimeUnit.MILLISECONDS);
            this.statistics.setRtcpPacketType(packetType);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. No more reports will be scheduled.");
        }
    }

    private void scheduleNow(RtcpPacketType packetType) {
        this.scheduledTask = new TxTask(packetType);
        try {
            this.reportTaskFuture = this.scheduler.submit((Runnable)this.scheduledTask);
            this.statistics.setRtcpPacketType(packetType);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. No more reports will be scheduled.");
        }
    }

    private void rescheduleRtcp(TxTask task, long timestamp) {
        this.reportTaskFuture.cancel(true);
        long interval = this.resolveInterval(timestamp);
        try {
            this.reportTaskFuture = this.scheduler.schedule((Runnable)task, interval, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. Scheduled report was canceled and cannot be re-scheduled.");
        }
    }

    public void enableSRTCP(DtlsHandler dtlsHandler) {
        this.dtlsHandler = dtlsHandler;
        this.secure = true;
    }

    public void disableSRTCP() {
        this.dtlsHandler = null;
        this.secure = false;
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int padding;
        int type;
        int version;
        byte b0 = packet[offset];
        int b0Int = b0 & 0xFF;
        return b0Int > 127 && b0Int < 192 && (version = (b0 & 0xC0) >> 6) == 2 && ((type = packet[offset + 1] & 0xFF) == 200 || type == 201) && (padding = (packet[offset] & 0x20) >> 5) == 0;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        if (!this.joined.get()) {
            return null;
        }
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return null;
        }
        if (!this.canHandle(packet, dataLength, offset)) {
            logger.warn((Object)"Cannot handle incoming packet!");
            throw new PacketHandlerException("Cannot handle incoming packet");
        }
        RtcpPacket rtcpPacket = new RtcpPacket();
        if (this.secure) {
            byte[] decoded = this.dtlsHandler.decodeRTCP(packet, offset, dataLength);
            if (decoded == null || decoded.length == 0) {
                logger.warn((Object)"Could not decode incoming SRTCP packet. Packet will be dropped.");
                return null;
            }
            rtcpPacket.decode(decoded, 0);
        } else {
            rtcpPacket.decode(packet, offset);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nRECEIVED " + rtcpPacket.toString()));
        }
        this.statistics.onRtcpReceive(rtcpPacket);
        if (RtcpPacketType.RTCP_BYE.equals((Object)rtcpPacket.getPacketType()) && RtcpPacketType.RTCP_REPORT.equals((Object)this.scheduledTask.getPacketType()) && this.statistics.getMembers() < this.statistics.getPmembers()) {
            long tc = this.statistics.getCurrentTime();
            this.tn = tc + (long)(this.statistics.getMembers() / this.statistics.getPmembers()) * (this.tn - tc);
            this.tp = tc - (long)(this.statistics.getMembers() / this.statistics.getPmembers()) * (tc - this.tp);
            this.rescheduleRtcp(this.scheduledTask, this.tn);
            this.statistics.confirmMembers();
        }
        return null;
    }

    private void sendRtcpPacket(RtcpPacket packet) throws IOException {
        RtcpPacketType type;
        if (this.joined.get()) {
            return;
        }
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return;
        }
        RtcpPacketType rtcpPacketType = type = packet.hasBye() ? RtcpPacketType.RTCP_BYE : RtcpPacketType.RTCP_REPORT;
        if (this.channel != null && this.channel.isOpen() && this.channel.isConnected()) {
            byte[] data = new byte[8192];
            packet.encode(data, 0);
            int dataLength = packet.getSize();
            if (this.secure) {
                data = this.dtlsHandler.encodeRTCP(data, 0, dataLength);
                dataLength = data.length;
            }
            this.byteBuffer.clear();
            this.byteBuffer.rewind();
            this.byteBuffer.put(data, 0, dataLength);
            this.byteBuffer.flip();
            this.byteBuffer.rewind();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nSENDING " + packet.toString()));
            }
            if (!this.channel.isOpen() || !this.channel.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not send " + (Object)((Object)type) + " packet because channel is closed or disconnected."));
                }
                return;
            }
            this.channel.send(this.byteBuffer, this.channel.getRemoteAddress());
            this.initial.set(false);
            this.statistics.onRtcpSent(packet);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not send " + (Object)((Object)type) + " packet because channel is closed or disconnected."));
        }
    }

    public synchronized void reset() {
        if (this.joined.get()) {
            throw new IllegalStateException("Cannot reset handler while is part of active RTP session.");
        }
        if (this.reportTaskFuture != null) {
            this.reportTaskFuture.cancel(false);
            this.reportTaskFuture = null;
            this.scheduledTask = null;
        }
        if (this.ssrcTaskFuture != null) {
            this.ssrcTaskFuture.cancel(false);
            this.ssrcTaskFuture = null;
        }
        this.tp = 0L;
        this.tn = -1L;
        this.initial.set(true);
        this.joined.set(false);
        if (this.secure) {
            this.disableSRTCP();
        }
    }

    private void closeChannel() {
        if (this.channel != null) {
            if (this.channel.isConnected()) {
                try {
                    this.channel.disconnect();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }

    private class SsrcTask
    implements Runnable {
        private SsrcTask() {
        }

        @Override
        public void run() {
            RtcpHandler.this.statistics.isSenderTimeout();
        }
    }

    private class TxTask
    implements Runnable {
        private final RtcpPacketType packetType;

        public TxTask(RtcpPacketType packetType) {
            this.packetType = packetType;
        }

        public RtcpPacketType getPacketType() {
            return this.packetType;
        }

        @Override
        public void run() {
            try {
                this.onExpire();
            }
            catch (IOException e) {
                logger.error((Object)"Cannot send scheduled RTCP report. Stopping handler.");
                RtcpHandler.this.reset();
            }
        }

        private void onExpire() throws IOException {
            long tc = RtcpHandler.this.statistics.getCurrentTime();
            switch (this.packetType) {
                case RTCP_REPORT: {
                    if (!RtcpHandler.this.joined.get()) break;
                    long t = RtcpHandler.this.statistics.rtcpInterval(RtcpHandler.this.initial.get());
                    RtcpHandler.this.tn = RtcpHandler.this.tp + t;
                    if (RtcpHandler.this.tn <= tc) {
                        RtcpPacket report = RtcpPacketFactory.buildReport(RtcpHandler.this.statistics);
                        RtcpHandler.this.sendRtcpPacket(report);
                        RtcpHandler.this.tp = tc;
                        t = RtcpHandler.this.statistics.rtcpInterval(RtcpHandler.this.initial.get());
                        RtcpHandler.this.tn = tc + t;
                    }
                    RtcpHandler.this.scheduleRtcp(RtcpHandler.this.tn, RtcpPacketType.RTCP_REPORT);
                    RtcpHandler.this.statistics.confirmMembers();
                    break;
                }
                case RTCP_BYE: {
                    long t = 0L;
                    RtcpHandler.this.tn = RtcpHandler.this.tp + t;
                    RtcpPacket bye = RtcpPacketFactory.buildBye(RtcpHandler.this.statistics);
                    RtcpHandler.this.statistics.setRtcpAvgSize(bye.getSize());
                    RtcpHandler.this.sendRtcpPacket(bye);
                    break;
                }
                default: {
                    logger.warn((Object)"Unkown scheduled event type!");
                }
            }
        }
    }
}

