/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceHandler;
import org.mobicents.media.io.ice.events.IceEventListener;
import org.mobicents.media.io.ice.events.SelectedCandidatesEvent;
import org.mobicents.media.server.impl.rtcp.RtcpHandler;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.network.channel.Channel;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.utils.Text;

public class RtcpChannel
extends MultiplexedChannel
implements DtlsListener,
IceEventListener {
    private static final Logger logger = Logger.getLogger(RtcpChannel.class);
    private final UdpManager udpManager;
    private int channelId;
    private boolean bound;
    private static final int STUN_PRIORITY = 3;
    private static final int RTCP_PRIORITY = 2;
    private static final int DTLS_PRIORITY = 1;
    private RtcpHandler rtcpHandler;
    private DtlsHandler dtlsHandler;
    private IceHandler stunHandler;
    private boolean ice;
    private boolean secure;
    private RtpListener rtpListener;

    public RtcpChannel(int channelId, RtpStatistics statistics, UdpManager udpManager) {
        this.udpManager = udpManager;
        this.channelId = channelId;
        this.bound = false;
        this.rtcpHandler = new RtcpHandler(udpManager.getScheduler(), statistics);
        this.dtlsHandler = new DtlsHandler();
        this.stunHandler = new IceHandler(2, (IceEventListener)this);
        this.secure = false;
    }

    public void setRemotePeer(SocketAddress remotePeer) {
        if (this.dataChannel != null) {
            boolean connectNow;
            if (this.dataChannel.isConnected()) {
                try {
                    this.dataChannel.disconnect();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (connectNow = this.udpManager.connectImmediately((InetSocketAddress)remotePeer)) {
                try {
                    this.dataChannel.connect(remotePeer);
                }
                catch (IOException e) {
                    logger.error((Object)"Can not connect to remote address. Check that you are not using local address (127.0.0.X)", (Throwable)e);
                }
            }
        }
    }

    public void setRtpListener(RtpListener rtpListener) {
        this.rtpListener = rtpListener;
    }

    public boolean isAvailable() {
        boolean available;
        boolean bl = available = this.dataChannel != null && this.dataChannel.isConnected();
        if (this.secure) {
            available = available && this.dtlsHandler.isHandshakeComplete();
        }
        return available;
    }

    public boolean isBound() {
        return this.bound;
    }

    private void onBinding() {
        this.rtcpHandler.setPipelinePriority(2);
        if (this.secure) {
            this.stunHandler.setPipelinePriority(3);
        }
        this.rtcpHandler.setChannel(this.dataChannel);
        this.handlers.addHandler((PacketHandler)this.rtcpHandler);
        if (this.secure) {
            this.dtlsHandler.setPipelinePriority(1);
            this.handlers.addHandler((PacketHandler)this.dtlsHandler);
            this.dtlsHandler.setChannel(this.dataChannel);
            this.dtlsHandler.addListener(this);
            this.handlers.addHandler((PacketHandler)this.stunHandler);
            this.dtlsHandler.handshake();
        } else {
            this.rtcpHandler.joinRtpSession();
        }
    }

    public void bind(boolean isLocal, int port) throws IOException {
        try {
            this.selectionKey = this.udpManager.open((Channel)this);
            this.dataChannel = (DatagramChannel)this.selectionKey.channel();
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        this.onBinding();
        this.udpManager.bind(this.dataChannel, port, isLocal);
        this.bound = true;
    }

    @Deprecated
    public void bind(DatagramChannel channel) throws SocketException {
        if (!channel.socket().isBound()) {
            throw new SocketException("Datagram channel is not bound!");
        }
        try {
            this.selectionKey = this.udpManager.open(channel, (Channel)this);
            this.dataChannel = channel;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        this.onBinding();
        this.bound = true;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void enableIce(IceAuthenticator authenticator) {
        if (!this.ice) {
            this.ice = true;
            this.stunHandler.setAuthenticator(authenticator);
            this.handlers.addHandler((PacketHandler)this.stunHandler);
        }
    }

    public void disableIce() {
        if (this.ice) {
            this.ice = false;
            this.handlers.removeHandler((PacketHandler)this.stunHandler);
        }
    }

    public void enableSRTCP(String hashFunction, String remotePeerFingerprint) {
        if (!this.secure) {
            this.secure = true;
            this.dtlsHandler.setRemoteFingerprint(hashFunction, remotePeerFingerprint);
            this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            this.dtlsHandler.setChannel(this.dataChannel);
            this.handlers.addHandler((PacketHandler)this.dtlsHandler);
        }
    }

    public void enableSRTCP() {
        if (!this.secure) {
            this.secure = true;
            this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            this.dtlsHandler.setChannel(this.dataChannel);
            this.handlers.addHandler((PacketHandler)this.dtlsHandler);
        }
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.dtlsHandler.setRemoteFingerprint(hashFunction, fingerprint);
    }

    public void disableSRTCP() {
        if (this.secure) {
            this.secure = false;
            if (this.dtlsHandler != null) {
                this.dtlsHandler.setRemoteFingerprint("", "");
            }
            this.dtlsHandler.resetLocalFingerprint();
            this.rtcpHandler.disableSRTCP();
        }
    }

    public Text getDtlsLocalFingerprint() {
        if (this.secure) {
            return new Text(this.dtlsHandler.getLocalFingerprint());
        }
        return new Text("");
    }

    public void close() {
        this.rtcpHandler.leaveRtpSession();
        this.bound = false;
        super.close();
        this.reset();
    }

    public void reset() {
        this.rtcpHandler.reset();
        if (this.ice) {
            this.disableIce();
            this.stunHandler.reset();
        }
        if (this.secure) {
            this.disableSRTCP();
            this.dtlsHandler.reset();
        }
    }

    @Override
    public void onDtlsHandshakeComplete() {
        logger.info((Object)"DTLS handshake completed for RTCP candidate.\nJoining RTP session.");
        this.rtcpHandler.joinRtpSession();
    }

    @Override
    public void onDtlsHandshakeFailed(Throwable e) {
        if (this.rtpListener != null) {
            this.rtpListener.onRtcpFailure(e);
        }
    }

    public void onSelectedCandidates(SelectedCandidatesEvent event) {
        try {
            this.connect(event.getRemotePeer());
            if (this.secure) {
                this.dtlsHandler.handshake();
            }
        }
        catch (IOException e) {
            this.rtpListener.onRtcpFailure(e);
        }
    }
}

