/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.chars;

import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.parser.chars.Lexer;
import gov.nist.javax.sip.parser.chars.Parser;
import java.text.ParseException;

public class StatusLineParser
extends Parser {
    public StatusLineParser(char[] statusLine) {
        this.lexer = new Lexer("status_lineLexer", statusLine);
    }

    public StatusLineParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("status_lineLexer");
    }

    protected int statusCode() throws ParseException {
        String scode = this.lexer.number();
        if (debug) {
            this.dbg_enter("statusCode");
        }
        try {
            int retval;
            int n = retval = Integer.parseInt(scode);
            return n;
        }
        catch (NumberFormatException ex) {
            throw new ParseException(this.lexer.getBuffer() + ":" + ex.getMessage(), this.lexer.getPtr());
        }
        finally {
            if (debug) {
                this.dbg_leave("statusCode");
            }
        }
    }

    protected String reasonPhrase() throws ParseException {
        return this.lexer.getRest().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine parse() throws ParseException {
        try {
            if (debug) {
                this.dbg_enter("parse");
            }
            StatusLine retval = new StatusLine();
            String version = this.sipVersion();
            retval.setSipVersion(version);
            this.lexer.SPorHT();
            int scode = this.statusCode();
            retval.setStatusCode(scode);
            this.lexer.SPorHT();
            String rp = this.reasonPhrase();
            retval.setReasonPhrase(rp);
            this.lexer.SPorHT();
            StatusLine statusLine = retval;
            return statusLine;
        }
        finally {
            if (debug) {
                this.dbg_leave("parse");
            }
        }
    }
}

