/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.chars;

import gov.nist.core.Host;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.header.ExtensionHeaderImpl;
import gov.nist.javax.sip.header.NameMap;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.chars.AddressParser;
import gov.nist.javax.sip.parser.chars.HeaderParser;
import gov.nist.javax.sip.parser.chars.HostNameParser;
import gov.nist.javax.sip.parser.chars.Lexer;
import gov.nist.javax.sip.parser.chars.ParserFactory;
import gov.nist.javax.sip.parser.chars.RequestLineParser;
import gov.nist.javax.sip.parser.chars.StatusLineParser;
import gov.nist.javax.sip.parser.chars.URLParser;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;

public class CharsMsgParser
implements MessageParser {
    protected static boolean computeContentLengthFromMessage = false;
    protected static final Charset charset = Charset.forName("UTF-8");
    protected static final char[] SIP_VERSION_CHAR = "SIP/2.0".toCharArray();

    public SIPMessage parseSIPMessage(byte[] msgBuffer, boolean readBody, boolean strict, ParseExceptionListener exhandler) throws ParseException {
        if (msgBuffer == null || msgBuffer.length == 0) {
            return null;
        }
        int i = 0;
        try {
            while (msgBuffer[i] < 32) {
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        char[] currentLine = null;
        char[] currentHeader = null;
        boolean isFirstLine = true;
        SIPMessage message = null;
        do {
            currentLine = null;
            int lineStart = i;
            try {
                while (msgBuffer[i] != 13 && msgBuffer[i] != 10) {
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            int lineLength = i - lineStart;
            ByteBuffer bb = ByteBuffer.wrap(msgBuffer, lineStart, lineLength);
            currentLine = charset.decode(bb).array();
            if ((currentLine = CharsMsgParser.trimEndOfLine(currentLine)).length == 0) {
                if (currentHeader != null && message != null) {
                    this.processHeader(currentHeader, message, exhandler, msgBuffer);
                }
            } else if (isFirstLine) {
                message = this.processFirstLine(currentLine, exhandler, msgBuffer);
            } else {
                char firstChar = currentLine[0];
                if (firstChar == '\t' || firstChar == ' ') {
                    if (currentHeader == null) {
                        throw new ParseException("Bad header continuation.", 0);
                    }
                    char[] retval = new char[currentHeader.length + currentLine.length - 1];
                    System.arraycopy(currentHeader, 0, retval, 0, currentHeader.length);
                    System.arraycopy(currentHeader, currentHeader.length, currentLine, 1, currentLine.length);
                } else {
                    if (currentHeader != null && message != null) {
                        this.processHeader(currentHeader, message, exhandler, msgBuffer);
                    }
                    currentHeader = new char[currentLine.length + 1];
                    System.arraycopy(currentLine, 0, currentHeader, 0, currentLine.length);
                    currentHeader[currentLine.length] = 10;
                }
            }
            if (msgBuffer[i] == 13 && msgBuffer.length > i + 1 && msgBuffer[i + 1] == 10) {
                ++i;
            }
            ++i;
            isFirstLine = false;
        } while (currentLine.length > 0);
        currentLine = null;
        currentHeader = null;
        if (message == null) {
            throw new ParseException("Bad message", 0);
        }
        message.setSize(i);
        if (readBody && message.getContentLength() != null) {
            String last4Chars;
            if (message.getContentLength().getContentLength() != 0) {
                int bodyLength = msgBuffer.length - i;
                byte[] body = new byte[bodyLength];
                System.arraycopy(msgBuffer, i, body, 0, bodyLength);
                message.setMessageContent(body, !strict, computeContentLengthFromMessage, message.getContentLength().getContentLength());
            } else if (!computeContentLengthFromMessage && message.getContentLength().getContentLength() == 0 & strict && !"\r\n\r\n".equals(last4Chars = new String(msgBuffer, msgBuffer.length - 4, 4))) {
                throw new ParseException("Extraneous characters at the end of the message ", i);
            }
        }
        return message;
    }

    protected static char[] trimEndOfLine(char[] line) {
        int i;
        if (line == null) {
            return line;
        }
        for (i = line.length - 1; i >= 0 && line[i] <= ' '; --i) {
        }
        if (i == line.length - 1) {
            return line;
        }
        if (i == -1) {
            return "".intern().toCharArray();
        }
        char[] retval = new char[i + 1];
        System.arraycopy(line, 0, retval, 0, i + 1);
        return retval;
    }

    protected SIPMessage processFirstLine(char[] firstLine, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        SIPRequest message;
        char[] retval = new char[firstLine.length + 1];
        System.arraycopy(firstLine, 0, retval, 0, firstLine.length);
        retval[firstLine.length] = 10;
        char[] sipVersionCompare = new char[7];
        System.arraycopy(firstLine, 0, sipVersionCompare, 0, 7);
        if (!Arrays.equals(sipVersionCompare, SIP_VERSION_CHAR)) {
            message = new SIPRequest();
            try {
                RequestLine requestLine = new RequestLineParser(retval).parse();
                message.setRequestLine(requestLine);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    parseExceptionListener.handleException(ex, (SIPMessage)message, RequestLine.class, String.valueOf(firstLine), String.valueOf(msgBuffer));
                }
                throw ex;
            }
        } else {
            message = new SIPResponse();
            try {
                StatusLine sl = new StatusLineParser(retval).parse();
                ((SIPResponse)message).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    parseExceptionListener.handleException(ex, (SIPMessage)message, StatusLine.class, String.valueOf(firstLine), String.valueOf(msgBuffer));
                }
                throw ex;
            }
        }
        return message;
    }

    protected void processHeader(char[] header, SIPMessage message, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        block6: {
            if (header == null || header.length == 0) {
                return;
            }
            HeaderParser headerParser = null;
            try {
                headerParser = ParserFactory.createParser(header);
            }
            catch (ParseException ex) {
                parseExceptionListener.handleException(ex, message, null, String.valueOf(header), String.valueOf(msgBuffer));
                return;
            }
            try {
                SIPHeader sipHeader = headerParser.parse();
                message.attachHeader(sipHeader, false);
            }
            catch (ParseException ex) {
                if (parseExceptionListener == null) break block6;
                String headerName = Lexer.getHeaderName(header);
                Class<ExtensionHeaderImpl> headerClass = NameMap.getClassFromName((String)headerName);
                if (headerClass == null) {
                    headerClass = ExtensionHeaderImpl.class;
                }
                parseExceptionListener.handleException(ex, message, headerClass, String.valueOf(header), String.valueOf(msgBuffer));
            }
        }
    }

    public AddressImpl parseAddress(char[] address) throws ParseException {
        AddressParser addressParser = new AddressParser(address);
        return addressParser.address(true);
    }

    public Host parseHost(char[] host) throws ParseException {
        Lexer lexer = new Lexer("charLexer", host);
        return new HostNameParser(lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(char[] telephone_number) throws ParseException {
        return new URLParser(telephone_number).parseTelephoneNumber(true);
    }

    public SipUri parseSIPUrl(char[] url) throws ParseException {
        try {
            return new URLParser(url).sipURL(true);
        }
        catch (ClassCastException ex) {
            throw new ParseException(url + " Not a SIP URL ", 0);
        }
    }

    public GenericURI parseUrl(char[] url) throws ParseException {
        return new URLParser(url).parse();
    }

    public RequestLine parseSIPRequestLine(char[] requestLine) throws ParseException {
        char[] retval = new char[requestLine.length + 1];
        System.arraycopy(requestLine, 0, retval, 0, requestLine.length);
        retval[requestLine.length] = 10;
        return new RequestLineParser(retval).parse();
    }

    public StatusLine parseSIPStatusLine(char[] statusLine) throws ParseException {
        char[] retval = new char[statusLine.length + 1];
        System.arraycopy(statusLine, 0, retval, 0, statusLine.length);
        retval[statusLine.length] = 10;
        return new StatusLineParser(statusLine).parse();
    }

    public static void setComputeContentLengthFromMessage(boolean computeContentLengthFromMessage) {
        CharsMsgParser.computeContentLengthFromMessage = computeContentLengthFromMessage;
    }

    public static void main(String[] args) throws ParseException {
        String[] messages = new String[]{"SIP/2.0 200 OK\r\nTo: \"The Little Blister\" <sip:LittleGuy@there.com>;tag=469bc066\r\nFrom: \"The Master Blaster\" <sip:BigGuy@here.com>;tag=11\r\nVia: SIP/2.0/UDP 139.10.134.246:5060;branch=z9hG4bK8b0a86f6_1030c7d18e0_17;received=139.10.134.246\r\nCall-ID: 1030c7d18ae_a97b0b_b@8b0a86f6\r\nCSeq: 1 SUBSCRIBE\r\nContact: <sip:172.16.11.162:5070>\r\nContent-Length: 0\r\n\r\n", "SIP/2.0 180 Ringing\r\nVia: SIP/2.0/UDP 172.18.1.29:5060;branch=z9hG4bK43fc10fb4446d55fc5c8f969607991f4\r\nTo: \"0440\" <sip:0440@212.209.220.131>;tag=2600\r\nFrom: \"Andreas\" <sip:andreas@e-horizon.se>;tag=8524\r\nCall-ID: f51a1851c5f570606140f14c8eb64fd3@172.18.1.29\r\nCSeq: 1 INVITE\r\nMax-Forwards: 70\r\nRecord-Route: <sip:212.209.220.131:5060>\r\nContent-Length: 0\r\n\r\n", "REGISTER sip:nist.gov SIP/2.0\r\nVia: SIP/2.0/UDP 129.6.55.182:14826\r\nMax-Forwards: 70\r\nFrom: <sip:mranga@nist.gov>;tag=6fcd5c7ace8b4a45acf0f0cd539b168b;epid=0d4c418ddf\r\nTo: <sip:mranga@nist.gov>\r\nCall-ID: c5679907eb954a8da9f9dceb282d7230@129.6.55.182\r\nCSeq: 1 REGISTER\r\nContact: <sip:129.6.55.182:14826>;methods=\"INVITE, MESSAGE, INFO, SUBSCRIBE, OPTIONS, BYE, CANCEL, NOTIFY, ACK, REFER\"\r\nUser-Agent: RTC/(Microsoft RTC)\r\nEvent:  registration\r\nAllow-Events: presence\r\nContent-Length: 0\r\n\r\nINVITE sip:littleguy@there.com:5060 SIP/2.0\r\nVia: SIP/2.0/UDP 65.243.118.100:5050\r\nFrom: M. Ranganathan  <sip:M.Ranganathan@sipbakeoff.com>;tag=1234\r\nTo: \"littleguy@there.com\" <sip:littleguy@there.com:5060> \r\nCall-ID: Q2AboBsaGn9!?x6@sipbakeoff.com \r\nCSeq: 1 INVITE \r\nContent-Length: 247\r\n\r\nv=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n"};
        class ParserThread
        implements Runnable {
            String[] messages;

            public ParserThread(String[] messagesToParse) {
                this.messages = messagesToParse;
            }

            public void run() {
                for (int i = 0; i < this.messages.length; ++i) {
                    CharsMsgParser smp = new CharsMsgParser();
                    try {
                        SIPMessage sipMessage = smp.parseSIPMessage(this.messages[i].getBytes(), true, true, null);
                        System.out.println(" i = " + i + " branchId = " + sipMessage.getTopmostVia().getBranch());
                        continue;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        new ParserThread(messages).run();
    }
}

