/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.widgetbuilder;

import android.content.Context;
import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.method.DateKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.AndroidValueAccessor;
import org.metawidget.android.widget.Stub;
import org.metawidget.android.widget.widgetprocessor.binding.BindingConverter;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidWidgetBuilder
implements WidgetBuilder<View, AndroidMetawidget>,
AndroidValueAccessor {
    @Override
    public Object getValue(View view) {
        if (view instanceof CheckBox) {
            return ((CheckBox)view).isChecked();
        }
        if (view instanceof TextView) {
            CharSequence text = ((TextView)view).getText();
            if (text instanceof SpannableStringBuilder) {
                text = text.toString();
            }
            return text;
        }
        if (view instanceof DatePicker) {
            DatePicker datePicker = (DatePicker)view;
            return new Date(datePicker.getYear() - 1900, datePicker.getMonth(), datePicker.getDayOfMonth());
        }
        if (view instanceof Spinner) {
            return ((Spinner)view).getSelectedItem();
        }
        return null;
    }

    @Override
    public boolean setValue(Object value, View view) {
        if (view instanceof CheckBox) {
            ((CheckBox)view).setChecked(((Boolean)value).booleanValue());
            return true;
        }
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)StringUtils.quietValueOf((Object)value));
            return true;
        }
        if (view instanceof DatePicker) {
            Date date = (Date)value;
            ((DatePicker)view).updateDate(1900 + date.getYear(), date.getMonth(), date.getDate());
            return true;
        }
        if (view instanceof Spinner) {
            AdapterView adapterView = (AdapterView)view;
            ArrayAdapter adapter = (ArrayAdapter)adapterView.getAdapter();
            adapterView.setSelection(adapter.getPosition(value));
            return true;
        }
        return false;
    }

    public View buildWidget(String elementName, Map<String, String> attributes, AndroidMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub(metawidget.getContext());
        }
        if ("action".equals(elementName)) {
            Button button = new Button(metawidget.getContext());
            button.setText((CharSequence)metawidget.getLabelString(attributes));
            return button;
        }
        Class clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class, (ClassLoader)this.getClass().getClassLoader());
        if (Boolean.class.equals((Object)clazz) && "true".equals(attributes.get("required"))) {
            return new CheckBox(metawidget.getContext());
        }
        if (clazz != null) {
            String lookup = attributes.get("lookup");
            if (lookup != null && !"".equals(lookup)) {
                String type;
                Spinner spinner = new Spinner(metawidget.getContext());
                ArrayList lookupList = CollectionUtils.newArrayList();
                if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
                    lookupList.add(null);
                }
                Class nonActualType = (type = attributes.get("type")) != null ? ClassUtils.niceForName((String)type) : null;
                BindingConverter bindingConverter = metawidget.getWidgetProcessor(BindingConverter.class);
                for (String value : CollectionUtils.fromString((String)lookup)) {
                    Object convertedValue = value;
                    if (bindingConverter != null && nonActualType != null) {
                        convertedValue = bindingConverter.convertFromString(value, nonActualType);
                    }
                    lookupList.add(convertedValue);
                }
                List lookupLabelsList = null;
                String lookupLabels = attributes.get("lookup-labels");
                lookupLabelsList = CollectionUtils.fromString((String)lookupLabels);
                if (!lookupLabelsList.isEmpty() && WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
                    lookupLabelsList.add(0, null);
                }
                LookupArrayAdapter adapter = new LookupArrayAdapter(metawidget.getContext(), lookupList, lookupLabelsList);
                spinner.setAdapter(adapter);
                return spinner;
            }
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckBox(metawidget.getContext());
                }
                if (Character.TYPE.equals(clazz)) {
                    EditText editText = new EditText(metawidget.getContext());
                    editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(1)});
                    return editText;
                }
                EditText editText = new EditText(metawidget.getContext());
                if (Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz)) {
                    editText.setKeyListener((KeyListener)new DigitsKeyListener());
                }
                return editText;
            }
            if (String.class.equals((Object)clazz)) {
                String maximumLength;
                EditText editText = new EditText(metawidget.getContext());
                if ("true".equals(attributes.get("masked"))) {
                    editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                if ("true".equals(attributes.get("large"))) {
                    editText.setMinLines(3);
                }
                if ((maximumLength = attributes.get("maximum-length")) != null && !"".equals(maximumLength)) {
                    editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(Integer.parseInt(maximumLength))});
                }
                return editText;
            }
            if (Character.class.equals((Object)clazz)) {
                EditText editText = new EditText(metawidget.getContext());
                editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(1)});
                return editText;
            }
            if (Date.class.equals((Object)clazz)) {
                if ("true".equals(attributes.get("required"))) {
                    return new DatePicker(metawidget.getContext());
                }
                EditText editText = new EditText(metawidget.getContext());
                editText.setKeyListener((KeyListener)new DateKeyListener());
                return editText;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                EditText editText = new EditText(metawidget.getContext());
                if (Byte.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                    editText.setKeyListener((KeyListener)new DigitsKeyListener());
                }
                return editText;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub(metawidget.getContext());
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new EditText(metawidget.getContext());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LookupArrayAdapter<T>
    extends ArrayAdapter<T> {
        private List<String> mLabels;

        public LookupArrayAdapter(Context context, List<T> values, List<String> labels) {
            super(context, 0, values);
            if (labels != null && !labels.isEmpty()) {
                if (labels.size() != values.size()) {
                    throw MetawidgetException.newException((String)"Labels list must be same size as values list");
                }
                this.mLabels = labels;
            }
        }

        public View getView(int position, View convertView, ViewGroup parentView) {
            return this.initView(position, convertView, parentView, 17367048);
        }

        public View getDropDownView(int position, View convertView, ViewGroup parentView) {
            return this.initView(position, convertView, parentView, 0x1090009);
        }

        private View initView(int position, View convertView, ViewGroup parentView, int textViewResourceId) {
            View viewToUse = convertView;
            if (viewToUse == null) {
                Context context = this.getContext();
                if (context != null) {
                    viewToUse = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(textViewResourceId, parentView, false);
                }
                if (viewToUse == null) {
                    viewToUse = new TextView(context);
                }
            }
            if (this.mLabels == null) {
                ((TextView)viewToUse).setText((CharSequence)StringUtils.quietValueOf((Object)this.getItem(position)));
            } else {
                ((TextView)viewToUse).setText((CharSequence)StringUtils.quietValueOf((Object)this.mLabels.get(position)));
            }
            return viewToUse;
        }
    }
}

