/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.layout;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.android.AndroidUtils;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.layout.AndroidNestedSectionLayoutDecorator;
import org.metawidget.android.widget.layout.TextViewLayoutDecoratorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextViewLayoutDecorator
extends AndroidNestedSectionLayoutDecorator {
    private int mStyle;

    public TextViewLayoutDecorator(TextViewLayoutDecoratorConfig config) {
        super(config);
        this.mStyle = config.getStyle();
    }

    protected ViewGroup createSectionWidget(ViewGroup previousSectionView, String section, Map<String, String> attributes, ViewGroup container, AndroidMetawidget metawidget) {
        TextView textView = new TextView(metawidget.getContext());
        AndroidUtils.applyStyle((View)textView, this.mStyle, metawidget);
        String localizedSection = metawidget.getLocalizedKey(StringUtils.camelCase((String)section));
        if (localizedSection == null) {
            localizedSection = section;
        }
        textView.setText((CharSequence)localizedSection, TextView.BufferType.SPANNABLE);
        HashMap sectionAttributes = CollectionUtils.newHashMap();
        sectionAttributes.put("label", "");
        sectionAttributes.put("large", "true");
        this.getDelegate().layoutWidget((Object)textView, "property", (Map)sectionAttributes, (Object)container, (Object)metawidget);
        LinearLayout newLayout = new LinearLayout(metawidget.getContext());
        newLayout.setOrientation(1);
        this.getDelegate().layoutWidget((Object)newLayout, "property", (Map)sectionAttributes, (Object)container, (Object)metawidget);
        return newLayout;
    }
}

