/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.layout;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Map;
import org.metawidget.android.AndroidUtils;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.Facet;
import org.metawidget.android.widget.Stub;
import org.metawidget.android.widget.layout.LinearLayoutConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearLayout
implements AdvancedLayout<View, ViewGroup, AndroidMetawidget> {
    private final int mLabelStyle;

    public LinearLayout() {
        this(new LinearLayoutConfig());
    }

    public LinearLayout(LinearLayoutConfig config) {
        this.mLabelStyle = config.getLabelStyle();
    }

    public void onStartBuild(AndroidMetawidget metawidget) {
    }

    public void startContainerLayout(ViewGroup container, AndroidMetawidget metawidget) {
    }

    public void layoutWidget(View view, String elementName, Map<String, String> attributes, ViewGroup container, AndroidMetawidget metawidget) {
        if (view instanceof Stub && ((Stub)view).getChildCount() == 0) {
            return;
        }
        ViewGroup viewToAddTo = this.newViewToAddTo(container);
        String labelText = metawidget.getLabelString(attributes);
        boolean needsLabel = SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName);
        if (needsLabel) {
            TextView textView = new TextView(metawidget.getContext());
            textView.setText((CharSequence)(labelText + ": "));
            AndroidUtils.applyStyle((View)textView, this.mLabelStyle, metawidget);
            viewToAddTo.addView((View)textView);
        }
        this.layoutWidget(view, viewToAddTo, container, needsLabel);
    }

    public void endContainerLayout(ViewGroup container, AndroidMetawidget metawidget) {
    }

    public void onEndBuild(AndroidMetawidget metawidget) {
        Facet viewButtons = metawidget.getFacet("buttons");
        if (viewButtons != null) {
            metawidget.addView((View)viewButtons, new LinearLayout.LayoutParams(-1, -2));
        }
    }

    protected void layoutWidget(View view, ViewGroup viewToAddTo, ViewGroup container, boolean hasLabel) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params == null) {
            params = view instanceof ListView ? new LinearLayout.LayoutParams(-1, 100) : new LinearLayout.LayoutParams(-1, -2);
        }
        this.getLayout(container).addView(view, params);
    }

    protected ViewGroup newViewToAddTo(ViewGroup metawidget) {
        return metawidget;
    }

    protected ViewGroup getLayout(ViewGroup container) {
        return container;
    }
}

