/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4HCCCtxInternal;

@NativeType(value="union LZ4_streamHC_t")
public class LZ4StreamHC
extends Struct<LZ4StreamHC> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINSTATESIZE;
    public static final int INTERNAL_DONOTUSE;

    protected LZ4StreamHC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LZ4StreamHC create(long address, @Nullable ByteBuffer container) {
        return new LZ4StreamHC(address, container);
    }

    public LZ4StreamHC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4StreamHC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[LZ4_STREAMHC_MINSIZE]")
    public ByteBuffer minStateSize() {
        return LZ4StreamHC.nminStateSize(this.address());
    }

    @NativeType(value="char")
    public byte minStateSize(int index) {
        return LZ4StreamHC.nminStateSize(this.address(), index);
    }

    @NativeType(value="struct LZ4HC_CCtx_internal")
    public LZ4HCCCtxInternal internal_donotuse() {
        return LZ4StreamHC.ninternal_donotuse(this.address());
    }

    public static LZ4StreamHC create(long address) {
        return new LZ4StreamHC(address, null);
    }

    @Nullable
    public static LZ4StreamHC createSafe(long address) {
        return address == 0L ? null : new LZ4StreamHC(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ByteBuffer nminStateSize(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)MINSTATESIZE), (int)262200);
    }

    public static byte nminStateSize(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)MINSTATESIZE + Checks.check((int)index, (int)262200) * 1L);
    }

    public static LZ4HCCCtxInternal ninternal_donotuse(long struct) {
        return LZ4HCCCtxInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4StreamHC.__union((Struct.Member[])new Struct.Member[]{LZ4StreamHC.__array((int)1, (int)262200), LZ4StreamHC.__member((int)LZ4HCCCtxInternal.SIZEOF, (int)LZ4HCCCtxInternal.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINSTATESIZE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamHC, Buffer> {
        private static final LZ4StreamHC ELEMENT_FACTORY = LZ4StreamHC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4StreamHC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[LZ4_STREAMHC_MINSIZE]")
        public ByteBuffer minStateSize() {
            return LZ4StreamHC.nminStateSize(this.address());
        }

        @NativeType(value="char")
        public byte minStateSize(int index) {
            return LZ4StreamHC.nminStateSize(this.address(), index);
        }

        @NativeType(value="struct LZ4HC_CCtx_internal")
        public LZ4HCCCtxInternal internal_donotuse() {
            return LZ4StreamHC.ninternal_donotuse(this.address());
        }
    }
}

