/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.lz4.LibLZ4;

public class LZ4HC {
    public static final int LZ4HC_CLEVEL_MIN = 3;
    public static final int LZ4HC_CLEVEL_DEFAULT = 9;
    public static final int LZ4HC_CLEVEL_OPT_MIN = 10;
    public static final int LZ4HC_CLEVEL_MAX = 12;
    public static final int LZ4HC_DICTIONARY_LOGSIZE = 16;
    public static final int LZ4HC_MAXD = 65536;
    public static final int LZ4HC_MAXD_MASK = 65535;
    public static final int LZ4HC_HASH_LOG = 15;
    public static final int LZ4HC_HASHTABLESIZE = 32768;
    public static final int LZ4HC_HASH_MASK = Short.MAX_VALUE;
    public static final int LZ4_STREAMHC_MINSIZE = 262200;

    protected LZ4HC() {
        throw new UnsupportedOperationException();
    }

    public static native int nLZ4_compress_HC(long var0, long var2, int var4, int var5, int var6);

    public static int LZ4_compress_HC(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC(MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    public static native int LZ4_sizeofStateHC();

    public static native int nLZ4_compress_HC_extStateHC(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_HC_extStateHC(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC_extStateHC(MemoryUtil.memAddress((ByteBuffer)state), MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    public static native int nLZ4_compress_HC_destSize(long var0, long var2, long var4, long var6, int var8, int var9);

    public static int LZ4_compress_HC_destSize(@NativeType(value="void *") ByteBuffer stateHC, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="int *") IntBuffer srcSizePtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)srcSizePtr, (int)1);
            Checks.check((Buffer)src, (int)srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4HC.nLZ4_compress_HC_destSize(MemoryUtil.memAddress((ByteBuffer)stateHC), MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), MemoryUtil.memAddress((IntBuffer)srcSizePtr), dst.remaining(), compressionLevel);
    }

    @NativeType(value="LZ4_streamHC_t *")
    public static native long LZ4_createStreamHC();

    public static native int nLZ4_freeStreamHC(long var0);

    public static int LZ4_freeStreamHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr) {
        if (Checks.CHECKS) {
            Checks.check((long)streamHCPtr);
        }
        return LZ4HC.nLZ4_freeStreamHC(streamHCPtr);
    }

    public static native void nLZ4_resetStreamHC_fast(long var0, int var2);

    public static void LZ4_resetStreamHC_fast(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((long)LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_resetStreamHC_fast(LZ4_streamHCPtr, compressionLevel);
    }

    public static native int nLZ4_loadDictHC(long var0, long var2, int var4);

    public static int LZ4_loadDictHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char const *") ByteBuffer dictionary) {
        if (Checks.CHECKS) {
            Checks.check((long)streamHCPtr);
        }
        return LZ4HC.nLZ4_loadDictHC(streamHCPtr, MemoryUtil.memAddress((ByteBuffer)dictionary), dictionary.remaining());
    }

    public static native int nLZ4_compress_HC_continue(long var0, long var2, long var4, int var6, int var7);

    public static int LZ4_compress_HC_continue(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((long)streamHCPtr);
        }
        return LZ4HC.nLZ4_compress_HC_continue(streamHCPtr, MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), src.remaining(), dst.remaining());
    }

    public static native int nLZ4_compress_HC_continue_destSize(long var0, long var2, long var4, long var6, int var8);

    public static int LZ4_compress_HC_continue_destSize(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="int *") IntBuffer srcSizePtr) {
        if (Checks.CHECKS) {
            Checks.check((long)streamHCPtr);
            Checks.check((Buffer)srcSizePtr, (int)1);
            Checks.check((Buffer)src, (int)srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4HC.nLZ4_compress_HC_continue_destSize(streamHCPtr, MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), MemoryUtil.memAddress((IntBuffer)srcSizePtr), dst.remaining());
    }

    public static native int nLZ4_saveDictHC(long var0, long var2, int var4);

    public static int LZ4_saveDictHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char *") ByteBuffer safeBuffer) {
        if (Checks.CHECKS) {
            Checks.check((long)streamHCPtr);
        }
        return LZ4HC.nLZ4_saveDictHC(streamHCPtr, MemoryUtil.memAddress((ByteBuffer)safeBuffer), safeBuffer.remaining());
    }

    public static native long nLZ4_initStreamHC(long var0, long var2);

    @NativeType(value="LZ4_streamHC_t *")
    public static long LZ4_initStreamHC(@NativeType(value="void *") ByteBuffer buffer) {
        return LZ4HC.nLZ4_initStreamHC(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native void nLZ4_setCompressionLevel(long var0, int var2);

    public static void LZ4_setCompressionLevel(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((long)LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_setCompressionLevel(LZ4_streamHCPtr, compressionLevel);
    }

    public static native void nLZ4_favorDecompressionSpeed(long var0, int var2);

    public static void LZ4_favorDecompressionSpeed(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, @NativeType(value="int") boolean favor) {
        if (Checks.CHECKS) {
            Checks.check((long)LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_favorDecompressionSpeed(LZ4_streamHCPtr, favor ? 1 : 0);
    }

    public static native int nLZ4_compress_HC_extStateHC_fastReset(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_HC_extStateHC_fastReset(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char * const") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC_extStateHC_fastReset(MemoryUtil.memAddress((ByteBuffer)state), MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddress((ByteBuffer)dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    public static native void nLZ4_attach_HC_dictionary(long var0, long var2);

    public static void LZ4_attach_HC_dictionary(@NativeType(value="LZ4_streamHC_t *") long working_stream, @NativeType(value="LZ4_streamHC_t * const") long dictionary_stream) {
        if (Checks.CHECKS) {
            Checks.check((long)working_stream);
        }
        LZ4HC.nLZ4_attach_HC_dictionary(working_stream, dictionary_stream);
    }

    static {
        LibLZ4.initialize();
    }
}

