/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4FAllocFunction;
import org.lwjgl.util.lz4.LZ4FAllocFunctionI;
import org.lwjgl.util.lz4.LZ4FCallocFunction;
import org.lwjgl.util.lz4.LZ4FCallocFunctionI;
import org.lwjgl.util.lz4.LZ4FFreeFunction;
import org.lwjgl.util.lz4.LZ4FFreeFunctionI;

@NativeType(value="struct LZ4F_CustomMem")
public class LZ4FCustomMem
extends Struct<LZ4FCustomMem>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMCALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUESTATE;

    protected LZ4FCustomMem(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LZ4FCustomMem create(long address, @Nullable ByteBuffer container) {
        return new LZ4FCustomMem(address, container);
    }

    public LZ4FCustomMem(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4FCustomMem.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4F_AllocFunction")
    public LZ4FAllocFunction customAlloc() {
        return LZ4FCustomMem.ncustomAlloc(this.address());
    }

    @Nullable
    @NativeType(value="LZ4F_CallocFunction")
    public LZ4FCallocFunction customCalloc() {
        return LZ4FCustomMem.ncustomCalloc(this.address());
    }

    @NativeType(value="LZ4F_FreeFunction")
    public LZ4FFreeFunction customFree() {
        return LZ4FCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaqueState() {
        return LZ4FCustomMem.nopaqueState(this.address());
    }

    public LZ4FCustomMem customAlloc(@NativeType(value="LZ4F_AllocFunction") LZ4FAllocFunctionI value) {
        LZ4FCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public LZ4FCustomMem customCalloc(@Nullable @NativeType(value="LZ4F_CallocFunction") LZ4FCallocFunctionI value) {
        LZ4FCustomMem.ncustomCalloc(this.address(), value);
        return this;
    }

    public LZ4FCustomMem customFree(@NativeType(value="LZ4F_FreeFunction") LZ4FFreeFunctionI value) {
        LZ4FCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public LZ4FCustomMem opaqueState(@NativeType(value="void *") long value) {
        LZ4FCustomMem.nopaqueState(this.address(), value);
        return this;
    }

    public LZ4FCustomMem set(LZ4FAllocFunctionI customAlloc, LZ4FCallocFunctionI customCalloc, LZ4FFreeFunctionI customFree, long opaqueState) {
        this.customAlloc(customAlloc);
        this.customCalloc(customCalloc);
        this.customFree(customFree);
        this.opaqueState(opaqueState);
        return this;
    }

    public LZ4FCustomMem set(LZ4FCustomMem src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LZ4FCustomMem malloc() {
        return new LZ4FCustomMem(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LZ4FCustomMem calloc() {
        return new LZ4FCustomMem(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LZ4FCustomMem create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LZ4FCustomMem(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LZ4FCustomMem create(long address) {
        return new LZ4FCustomMem(address, null);
    }

    @Nullable
    public static LZ4FCustomMem createSafe(long address) {
        return address == 0L ? null : new LZ4FCustomMem(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LZ4FCustomMem.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FCustomMem.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LZ4FCustomMem malloc(MemoryStack stack) {
        return new LZ4FCustomMem(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LZ4FCustomMem calloc(MemoryStack stack) {
        return new LZ4FCustomMem(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LZ4FAllocFunction ncustomAlloc(long struct) {
        return LZ4FAllocFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
    }

    @Nullable
    public static LZ4FCallocFunction ncustomCalloc(long struct) {
        return LZ4FCallocFunction.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMCALLOC)));
    }

    public static LZ4FFreeFunction ncustomFree(long struct) {
        return LZ4FFreeFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
    }

    public static long nopaqueState(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OPAQUESTATE));
    }

    public static void ncustomAlloc(long struct, LZ4FAllocFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMALLOC), (long)value.address());
    }

    public static void ncustomCalloc(long struct, @Nullable LZ4FCallocFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMCALLOC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ncustomFree(long struct, LZ4FFreeFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMFREE), (long)value.address());
    }

    public static void nopaqueState(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OPAQUESTATE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)OPAQUESTATE)));
    }

    static {
        Struct.Layout layout = LZ4FCustomMem.__struct((Struct.Member[])new Struct.Member[]{LZ4FCustomMem.__member((int)POINTER_SIZE), LZ4FCustomMem.__member((int)POINTER_SIZE), LZ4FCustomMem.__member((int)POINTER_SIZE), LZ4FCustomMem.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMCALLOC = layout.offsetof(1);
        CUSTOMFREE = layout.offsetof(2);
        OPAQUESTATE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LZ4FCustomMem, Buffer>
    implements NativeResource {
        private static final LZ4FCustomMem ELEMENT_FACTORY = LZ4FCustomMem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4FCustomMem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4F_AllocFunction")
        public LZ4FAllocFunction customAlloc() {
            return LZ4FCustomMem.ncustomAlloc(this.address());
        }

        @Nullable
        @NativeType(value="LZ4F_CallocFunction")
        public LZ4FCallocFunction customCalloc() {
            return LZ4FCustomMem.ncustomCalloc(this.address());
        }

        @NativeType(value="LZ4F_FreeFunction")
        public LZ4FFreeFunction customFree() {
            return LZ4FCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaqueState() {
            return LZ4FCustomMem.nopaqueState(this.address());
        }

        public Buffer customAlloc(@NativeType(value="LZ4F_AllocFunction") LZ4FAllocFunctionI value) {
            LZ4FCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customCalloc(@Nullable @NativeType(value="LZ4F_CallocFunction") LZ4FCallocFunctionI value) {
            LZ4FCustomMem.ncustomCalloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="LZ4F_FreeFunction") LZ4FFreeFunctionI value) {
            LZ4FCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaqueState(@NativeType(value="void *") long value) {
            LZ4FCustomMem.nopaqueState(this.address(), value);
            return this;
        }
    }
}

