/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class AggregatedList<T>
extends AbstractList<T> {
    protected List<Integer> subIndexes = new ArrayList<Integer>();
    protected List<List<T>> subLists = new ArrayList<List<T>>();

    protected int lastIndex() {
        if (this.subIndexes.isEmpty()) {
            return 0;
        }
        return this.subIndexes.get(this.subIndexes.size() - 1);
    }

    public void addSubList(List<T> l) {
        this.subIndexes.add(this.lastIndex() + l.size());
        this.subLists.add(l);
    }

    @Override
    public int size() {
        return this.lastIndex();
    }

    @Override
    public T get(int index) {
        for (int i = 0; i < this.subIndexes.size(); ++i) {
            Integer relIndex = this.subIndexes.get(i);
            if (index >= relIndex) continue;
            List<T> subList = this.subLists.get(i);
            int realIndex = index - (relIndex - subList.size());
            return subList.get(realIndex);
        }
        throw new IndexOutOfBoundsException("The last index allowed is: " + this.lastIndex());
    }
}

