"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createProcessDefinitionList = exports.getActiveTaskStates = exports.getAllTaskStates = exports.trimTaskEndpoint = exports.resolveTaskPriority = exports.getTaskEndpointSecurityParams = exports.getTaskSchemaEndPoint = void 0;
var getTaskSchemaEndPoint = function (task, user) {
    var params = '';
    var endpoint = task.endpoint;
    if (task.completed) {
        endpoint = endpoint.slice(0, -(task.id.length + 1));
        endpoint = endpoint.replace(task.processInstanceId + '/', '');
    }
    else {
        params = "?".concat((0, exports.getTaskEndpointSecurityParams)(user));
    }
    return "".concat(endpoint, "/schema").concat(params);
};
exports.getTaskSchemaEndPoint = getTaskSchemaEndPoint;
var getTaskEndpointSecurityParams = function (user) {
    var groups = '';
    if (user.groups && user.groups.length > 0) {
        groups = "&group=".concat(user.groups.join('&group='));
    }
    return "user=".concat(user.id).concat(groups);
};
exports.getTaskEndpointSecurityParams = getTaskEndpointSecurityParams;
var resolveTaskPriority = function (priority) {
    switch (priority) {
        case '0':
            return '0 - High';
        case '5':
            return '5 - Medium';
        case '10':
            return '10 - Low';
    }
    return priority || '-';
};
exports.resolveTaskPriority = resolveTaskPriority;
var trimTaskEndpoint = function (userTask) {
    if (userTask.endpoint) {
        var endpoint = userTask.endpoint;
        var pid = userTask.processInstanceId;
        return "".concat(endpoint.substring(0, endpoint.indexOf(pid)), "...");
    }
    return '-';
};
exports.trimTaskEndpoint = trimTaskEndpoint;
var getAllTaskStates = function () {
    if (window.KOGITO_TASK_STATES_LIST) {
        return window.KOGITO_TASK_STATES_LIST.split(',').map(function (state) {
            return state.trim();
        });
    }
    if (process.env.KOGITO_TASK_STATES_LIST) {
        return process.env.KOGITO_TASK_STATES_LIST.split(',').map(function (state) {
            return state.trim();
        });
    }
    return ['Ready', 'Reserved', 'Completed', 'Aborted', 'Skipped'];
};
exports.getAllTaskStates = getAllTaskStates;
var getActiveTaskStates = function () {
    if (window.KOGITO_TASK_ACTIVE_STATES_LIST) {
        return window.KOGITO_TASK_ACTIVE_STATES_LIST.split(',').map(function (state) {
            return state.trim();
        });
    }
    if (process.env.KOGITO_TASK_ACTIVE_STATES_LIST) {
        return process.env.KOGITO_TASK_ACTIVE_STATES_LIST.split(',').map(function (state) {
            return state.trim();
        });
    }
    return ['Ready', 'Reserved'];
};
exports.getActiveTaskStates = getActiveTaskStates;
var createProcessDefinitionList = function (processDefinitionObjs, url) {
    var processDefinitionList = [];
    processDefinitionObjs.forEach(function (processDefObj) {
        var processName = Object.keys(processDefObj)[0].split('/')[1];
        var endpoint = "".concat(url, "/").concat(processName);
        processDefinitionList.push({
            processName: processName,
            endpoint: endpoint
        });
    });
    return processDefinitionList;
};
exports.createProcessDefinitionList = createProcessDefinitionList;
//# sourceMappingURL=Utils.js.map