import { EnvelopeServer } from '@kogito-tooling/envelope-bus/dist/channel';
import { RuntimeToolsDevUIChannelApi, RuntimeToolsDevUIEnvelopeApi, User } from '../api';
import { CustomLabels } from '../api/CustomLabels';
import { DiagramPreviewSize } from '@kogito-apps/process-details/dist/api';
export interface StandaloneDevUIApi {
    close: () => void;
}
export interface Consoles {
    open: (args: {
        container: Element;
        users: User[];
        dataIndexUrl: string;
        trustyServiceUrl: string;
        page: string;
        devUIUrl: string;
        openApiPath: string;
        origin?: string;
        availablePages?: string[];
        customLabels?: CustomLabels;
        omittedProcessTimelineEvents?: string[];
        diagramPreviewSize?: DiagramPreviewSize;
        isStunnerEnabled: boolean;
    }) => StandaloneDevUIApi;
}
declare global {
    interface Window {
        RuntimeToolsDevUI: Consoles;
    }
}
export declare const createDevUI: (envelopeServer: EnvelopeServer<RuntimeToolsDevUIChannelApi, RuntimeToolsDevUIEnvelopeApi>, listener: (message: MessageEvent) => void, iframe: HTMLIFrameElement) => any;
export declare function open(args: {
    container: Element;
    isDataIndexAvailable: boolean;
    isTracingEnabled: boolean;
    users: User[];
    dataIndexUrl: string;
    trustyServiceUrl: string;
    page: string;
    devUIUrl: string;
    openApiPath: string;
    origin?: string;
    availablePages?: string[];
    customLabels?: CustomLabels;
    omittedProcessTimelineEvents?: string[];
    isStunnerEnabled: boolean;
    diagramPreviewSize?: DiagramPreviewSize;
}): StandaloneDevUIApi;
