"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var envelope_1 = require("@kogito-tooling/envelope");
var envelope_2 = require("../envelope");
var initEnvelope = function () {
    var container = document.getElementById('envelope-app');
    var bus = {
        postMessage: function (message, targetOrigin, _) {
            return window.parent.postMessage(message, targetOrigin, _);
        }
    };
    var apiImplFactory = {
        create: function (args) { return new envelope_2.RuntimeToolsDevUIEnvelopeApiImpl(args); }
    };
    var envelope = new envelope_1.Envelope(bus);
    var runtimeToolsDevUIEnvelope = new envelope_2.RuntimeToolsDevUIEnvelope(envelope, apiImplFactory);
    runtimeToolsDevUIEnvelope.start(container);
};
if (document.readyState !== 'loading') {
    initEnvelope();
}
else {
    document.addEventListener('DOMContentLoaded', function () {
        initEnvelope();
    });
}
//# sourceMappingURL=EnvelopeApp.js.map