"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var DevUIAppContext_1 = require("../../../contexts/DevUIAppContext");
require("../../../styles.css");
var TaskInboxSwitchUser = function (_a) {
    var user = _a.user, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var _b = __read((0, react_1.useState)(false), 2), isDropDownOpen = _b[0], setIsDropDownOpen = _b[1];
    var _c = __read((0, react_1.useState)(user), 2), currentUser = _c[0], setCurrentUser = _c[1];
    var allUsers = appContext.getAllUsers();
    var onSelect = function (event) {
        var selectedUser = event.target.innerHTML;
        appContext.switchUser(selectedUser);
        setCurrentUser(selectedUser);
        setIsDropDownOpen(!isDropDownOpen);
    };
    var dropdownItems = function () {
        var userIds = [];
        allUsers.forEach(function (userObj) {
            userIds.push((0, jsx_runtime_1.jsx)(react_core_1.DropdownItem, { children: userObj.id }, userObj.id));
        });
        return userIds;
    };
    var onToggle = function (isOpen) {
        setIsDropDownOpen(isOpen);
    };
    return ((0, jsx_runtime_1.jsx)(react_core_1.Dropdown, __assign({ onSelect: onSelect, toggle: (0, jsx_runtime_1.jsx)(react_core_1.DropdownToggle, __assign({ onToggle: onToggle, "aria-label": "Applications", id: "toggle-id-7", toggleIndicator: react_icons_1.CaretDownIcon, icon: (0, jsx_runtime_1.jsx)(react_icons_1.UserIcon, {}) }, { children: currentUser })), isOpen: isDropDownOpen, isPlain: true, dropdownItems: dropdownItems(), className: "DevUI-switchUser-dropdown-styling" }, (0, ouia_tools_1.componentOuiaProps)(ouiaId, 'task-inbox-switch-user', ouiaSafe))));
};
exports.default = TaskInboxSwitchUser;
//# sourceMappingURL=TaskInboxSwitchUser.js.map