"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var consoles_common_1 = require("@kogito-apps/consoles-common");
var TaskInboxContainer_1 = __importDefault(require("../../containers/TaskInboxContainer/TaskInboxContainer"));
var TaskInboxSwitchUser_1 = __importDefault(require("./components/TaskInboxSwitchUser"));
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
require("../../styles.css");
var TaskInboxPage = function (ouiaId, ouiaSafe) {
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var user = appContext.getCurrentUser().id;
    (0, react_1.useEffect)(function () {
        return (0, ouia_tools_1.ouiaPageTypeAndObjectId)('task-inbox-page');
    });
    var renderTaskInbox = function () {
        return (0, jsx_runtime_1.jsx)(TaskInboxContainer_1.default, {});
    };
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsx)(react_core_1.PageSection, __assign({ variant: "light" }, (0, ouia_tools_1.componentOuiaProps)('header' + (ouiaId ? '-' + ouiaId : ''), 'task-inbox-page', ouiaSafe), { children: (0, jsx_runtime_1.jsxs)(react_core_1.Grid, { children: [(0, jsx_runtime_1.jsx)(react_core_1.GridItem, __assign({ span: 10 }, { children: (0, jsx_runtime_1.jsx)(consoles_common_1.PageTitle, { title: "Task Inbox" }) })), (0, jsx_runtime_1.jsx)(react_core_1.GridItem, __assign({ span: 2 }, { children: user.length > 0 && (0, jsx_runtime_1.jsx)(TaskInboxSwitchUser_1.default, { user: user }) }))] }) })), (0, jsx_runtime_1.jsx)(react_core_1.PageSection, __assign({}, (0, ouia_tools_1.componentOuiaProps)('content' + (ouiaId ? '-' + ouiaId : ''), 'task-inbox-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(react_core_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: renderTaskInbox() })) }))] }));
};
exports.default = TaskInboxPage;
//# sourceMappingURL=TaskInboxPage.js.map