"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InlineEdit = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
exports.InlineEdit = react_1.default.forwardRef(function (_a, forwardedRef) {
    var setBusinessKey = _a.setBusinessKey, getBusinessKey = _a.getBusinessKey, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var _b = __read((0, react_1.useState)(false), 2), isEditable = _b[0], setIsEditable = _b[1];
    var _c = __read((0, react_1.useState)(''), 2), inputValue = _c[0], setInputValue = _c[1];
    var _d = __read((0, react_1.useState)(getBusinessKey()), 2), currentBusinessKey = _d[0], setCurrentBusinessKey = _d[1];
    (0, react_1.useEffect)(function () {
        if (currentBusinessKey.length === 0) {
            setInputValue('');
        }
    }, [currentBusinessKey]);
    var toggleEditableMode = function () {
        setIsEditable(!isEditable);
    };
    var confirmBusinessKey = function (isConfirmed) {
        if (isConfirmed) {
            setBusinessKey(inputValue);
            setCurrentBusinessKey(inputValue);
        }
        toggleEditableMode();
    };
    (0, react_1.useImperativeHandle)(forwardedRef, function () { return ({
        reset: function () {
            setInputValue('');
            setCurrentBusinessKey('');
        }
    }); }, []);
    return ((0, jsx_runtime_1.jsxs)("div", __assign({}, (0, ouia_tools_1.componentOuiaProps)(ouiaId, 'inline-edit', ouiaSafe), { className: "pf-c-inline-edit ".concat(isEditable && 'pf-m-inline-editable'), id: "inline-edit-toggle-example" }, { children: [(0, jsx_runtime_1.jsxs)("div", __assign({ className: "pf-c-inline-edit__group" }, { children: [(0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-inline-edit__value", id: "single-editable-example-label" }, { children: currentBusinessKey.length > 0 ? (currentBusinessKey) : ((0, jsx_runtime_1.jsx)("span", __assign({ className: "pf-u-disabled-color-100" }, { children: "Business key" }))) })), (0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-inline-edit__action pf-m-enable-editable" }, { children: (0, jsx_runtime_1.jsx)(react_core_1.Button, __assign({ variant: "plain", onClick: toggleEditableMode }, { children: (0, jsx_runtime_1.jsx)(react_icons_1.PencilAltIcon, {}) })) }))] })), (0, jsx_runtime_1.jsxs)("div", __assign({ className: "pf-c-inline-edit__group" }, { children: [(0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-inline-edit__input" }, { children: (0, jsx_runtime_1.jsx)(react_core_1.TextInput, { value: inputValue, type: "text", placeholder: 'Enter business key', onChange: setInputValue, "aria-label": "text input example" }) })), (0, jsx_runtime_1.jsxs)("div", __assign({ className: "pf-c-inline-edit__group pf-m-action-group pf-m-icon-group" }, { children: [(0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-inline-edit__action pf-m-valid" }, { children: (0, jsx_runtime_1.jsx)(react_core_1.Button, __assign({ variant: "plain", onClick: function () { return confirmBusinessKey(true); } }, { children: (0, jsx_runtime_1.jsx)(react_icons_1.CheckIcon, {}) })) })), (0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-inline-edit__action" }, { children: (0, jsx_runtime_1.jsx)(react_core_1.Button, __assign({ variant: "plain", onClick: function () { return confirmBusinessKey(false); } }, { children: (0, jsx_runtime_1.jsx)(react_icons_1.TimesIcon, {}) })) }))] }))] }))] })));
});
exports.default = exports.InlineEdit;
//# sourceMappingURL=InlineEdit.js.map