"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var consoles_common_1 = require("@kogito-apps/consoles-common");
var ProcessListContext_1 = require("../../../channel/ProcessList/ProcessListContext");
var MonitoringContainer_1 = __importDefault(require("../../containers/MonitoringContainer/MonitoringContainer"));
var components_common_1 = require("@kogito-apps/components-common");
require("../../styles.css");
var management_console_shared_1 = require("@kogito-apps/management-console-shared");
var monitoring_1 = require("@kogito-apps/monitoring");
var MonitoringPage = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe, dataIndexUrl = _a.dataIndexUrl;
    var gatewayApi = (0, ProcessListContext_1.useProcessListGatewayApi)();
    var _b = __read((0, react_1.useState)(false), 2), hasWorkflow = _b[0], setHasWorkflow = _b[1];
    var _c = __read((0, react_1.useState)(true), 2), loading = _c[0], setLoading = _c[1];
    var _d = __read((0, react_1.useState)(false), 2), openProcessSelect = _d[0], setOpenProcessSelect = _d[1];
    var _e = __read((0, react_1.useState)(monitoring_1.Dashboard.MONITORING), 2), dashboard = _e[0], setDashboard = _e[1];
    var _f = __read((0, react_1.useState)([]), 2), workflowList = _f[0], setWorkflowList = _f[1];
    var _g = __read((0, react_1.useState)(), 2), selectedWorkflow = _g[0], setSelectedWorkflow = _g[1];
    var _h = __read((0, react_1.useState)(0), 2), activeTabKey = _h[0], setActiveTabKey = _h[1];
    var initialLoad = function () {
        return gatewayApi.initialLoad({
            status: [
                management_console_shared_1.ProcessInstanceState.Aborted,
                management_console_shared_1.ProcessInstanceState.Active,
                management_console_shared_1.ProcessInstanceState.Completed,
                management_console_shared_1.ProcessInstanceState.Error,
                management_console_shared_1.ProcessInstanceState.Suspended
            ],
            businessKey: []
        }, { start: management_console_shared_1.OrderBy.DESC });
    };
    var loadWorkflowList = (0, react_1.useCallback)(function () {
        gatewayApi.query(0, 1000).then(function (list) {
            setSelectedWorkflow(list[0]);
            setWorkflowList(list);
        });
    }, [workflowList, selectedWorkflow]);
    (0, react_1.useEffect)(function () {
        var intervaId = setInterval(function () {
            if (!hasWorkflow) {
                initialLoad();
                gatewayApi.query(0, 1).then(function (list) {
                    if (list.length > 0) {
                        setHasWorkflow(true);
                        loadWorkflowList();
                    }
                    setLoading(false);
                });
            }
        }, 500);
        return function () { return clearInterval(intervaId); };
    }, [hasWorkflow, loading]);
    (0, react_1.useEffect)(function () {
        if (dashboard === monitoring_1.Dashboard.DETAILS) {
            loadWorkflowList();
        }
    }, [dashboard]);
    (0, react_1.useEffect)(function () {
        return (0, ouia_tools_1.ouiaPageTypeAndObjectId)('monitoring');
    });
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsx)(consoles_common_1.PageSectionHeader, { titleText: "Monitoring", ouiaId: ouiaId }), hasWorkflow ? ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsxs)(react_core_1.Tabs, __assign({ activeKey: activeTabKey, onSelect: function (event, tabIndex) {
                            setActiveTabKey(tabIndex);
                            var dashboard = tabIndex === 0 ? monitoring_1.Dashboard.MONITORING : monitoring_1.Dashboard.DETAILS;
                            setDashboard(dashboard);
                            loadWorkflowList();
                        }, isBox: true, variant: "light300", style: {
                            background: 'white'
                        } }, { children: [(0, jsx_runtime_1.jsx)(react_core_1.Tab, { id: "monitoring-report-tab", eventKey: 0, title: (0, jsx_runtime_1.jsx)(react_core_1.TabTitleText, { children: "Summary" }) }), (0, jsx_runtime_1.jsx)(react_core_1.Tab, { id: "monitoring-workflow-tab", eventKey: 1, title: (0, jsx_runtime_1.jsx)(react_core_1.TabTitleText, { children: "Workflows" }) })] })), (0, jsx_runtime_1.jsx)(react_core_1.PageSection, __assign({}, (0, ouia_tools_1.componentOuiaProps)(ouiaId, 'monitoring-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsxs)(react_core_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: [dashboard === monitoring_1.Dashboard.DETAILS && ((0, jsx_runtime_1.jsx)(react_core_1.Toolbar, { children: (0, jsx_runtime_1.jsx)(react_core_1.ToolbarContent, { children: (0, jsx_runtime_1.jsx)(react_core_1.ToolbarGroup, { children: (0, jsx_runtime_1.jsx)(react_core_1.ToolbarItem, { children: (0, jsx_runtime_1.jsx)(react_core_1.Select, __assign({ "aria-labelledby": 'workfflow-id-select', variant: react_core_1.SelectVariant.single, onSelect: function (event, v) {
                                                        setSelectedWorkflow(workflowList.find(function (p) { return p.id === v; }));
                                                        setOpenProcessSelect(false);
                                                    }, onToggle: function () {
                                                        return setOpenProcessSelect(!openProcessSelect);
                                                    }, isOpen: openProcessSelect, placeholderText: "Select Workflow", hasInlineFilter: true, maxHeight: '300px' }, { children: workflowList.map(function (p, i) { return ((0, jsx_runtime_1.jsx)(react_core_1.SelectOption, { value: p.id, description: p.processId }, i)); }) })) }) }) }) })), (0, jsx_runtime_1.jsx)(MonitoringContainer_1.default, { dataIndexUrl: dataIndexUrl, workflow: selectedWorkflow ? selectedWorkflow.id : undefined, dashboard: dashboard })] })) }))] })) : ((0, jsx_runtime_1.jsx)(components_common_1.KogitoEmptyState, { title: loading ? 'Loading' : 'No Data', body: loading ? 'Loading Data' : 'No workflows were started', type: components_common_1.KogitoEmptyStateType.Info }))] }));
};
exports.default = MonitoringPage;
//# sourceMappingURL=MonitoringPage.js.map