"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudEventPageSource = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
require("../../styles.css");
var consoles_common_1 = require("@kogito-apps/consoles-common");
var components_common_1 = require("@kogito-apps/components-common");
var react_router_dom_1 = require("react-router-dom");
var CloudEventFormContainer_1 = __importDefault(require("../../containers/CloudEventFormContainer/CloudEventFormContainer"));
var CloudEventPageSource;
(function (CloudEventPageSource) {
    CloudEventPageSource["DEFINITIONS"] = "definitions";
    CloudEventPageSource["INSTANCES"] = "instances";
})(CloudEventPageSource = exports.CloudEventPageSource || (exports.CloudEventPageSource = {}));
var CloudEventFormPage = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var _b = __read((0, react_1.useState)(), 2), notification = _b[0], setNotification = _b[1];
    var history = (0, react_router_dom_1.useHistory)();
    var isTriggerNewInstance = (0, react_1.useMemo)(function () {
        var _a;
        var source = (_a = history === null || history === void 0 ? void 0 : history.location) === null || _a === void 0 ? void 0 : _a.state['source'];
        return source === CloudEventPageSource.DEFINITIONS;
    }, [history]);
    var showNotification = (0, react_1.useCallback)(function (notificationType, submitMessage, notificationDetails) {
        setNotification({
            type: notificationType,
            message: submitMessage,
            details: notificationDetails,
            customActions: [
                {
                    label: 'Go to workflow list',
                    onClick: function () {
                        setNotification(null);
                        history.push('/Processes');
                    }
                }
            ],
            close: function () {
                setNotification(null);
            }
        });
    }, []);
    var onSubmitSuccess = (0, react_1.useCallback)(function (message) {
        showNotification('success', message);
    }, []);
    var onSubmitError = (0, react_1.useCallback)(function (details) {
        var message = 'Failed to trigger workflow.';
        showNotification('error', message, details);
    }, []);
    (0, react_1.useEffect)(function () {
        return (0, ouia_tools_1.ouiaPageTypeAndObjectId)('trigger-cloud-event-form');
    }, []);
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsxs)(react_core_1.PageSection, __assign({}, (0, ouia_tools_1.componentOuiaProps)("title".concat(ouiaId ? '-' + ouiaId : ''), 'trigger-cloud-event-form-page-section', ouiaSafe), { variant: "light" }, { children: [(0, jsx_runtime_1.jsx)(consoles_common_1.PageTitle, { title: "Trigger Cloud Event" }), notification && ((0, jsx_runtime_1.jsx)("div", { children: (0, jsx_runtime_1.jsx)(components_common_1.FormNotification, { notification: notification }) }))] })), (0, jsx_runtime_1.jsx)(react_core_1.PageSection, __assign({}, (0, ouia_tools_1.componentOuiaProps)("content".concat(ouiaId ? '-' + ouiaId : ''), 'cloud-event-form-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(react_core_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: (0, jsx_runtime_1.jsx)(react_core_1.CardBody, __assign({ className: "pf-u-h-100" }, { children: (0, jsx_runtime_1.jsx)(CloudEventFormContainer_1.default, { isTriggerNewInstance: isTriggerNewInstance, onSuccess: function (id) { return onSubmitSuccess(id); }, onError: function (details) { return onSubmitError(details); } }) })) })) }))] }));
};
exports.default = CloudEventFormPage;
//# sourceMappingURL=CloudEventFormPage.js.map