import React from 'react';
import { User } from '@kogito-apps/consoles-common';
import { CustomLabels } from '../../api/CustomLabels';
import { DiagramPreviewSize } from '@kogito-apps/process-details/dist/api';
export interface DevUIAppContext {
    isProcessEnabled: boolean;
    isTracingEnabled: boolean;
    getCurrentUser(): User;
    getAllUsers(): User[];
    switchUser(userId: string): void;
    onUserChange(listener: UserChangeListener): UnSubscribeHandler;
    getDevUIUrl(): string;
    getOpenApiPath(): string;
    availablePages?: string[];
    customLabels: CustomLabels;
    omittedProcessTimelineEvents: string[];
    diagramPreviewSize?: DiagramPreviewSize;
    isWorkflow(): boolean;
    isStunnerEnabled: boolean;
    getIsStunnerEnabled(): boolean;
}
export interface UserChangeListener {
    onUserChange: (user: User) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export type DevUIAppContextArgs = {
    users?: User[];
    devUIUrl: string;
    openApiPath: string;
    isProcessEnabled: boolean;
    isTracingEnabled: boolean;
    availablePages?: string[];
    customLabels?: CustomLabels;
    omittedProcessTimelineEvents: string[];
    diagramPreviewSize?: DiagramPreviewSize;
    isStunnerEnabled: boolean;
};
export declare class DevUIAppContextImpl implements DevUIAppContext {
    private readonly args;
    private currentUser;
    private readonly userListeners;
    constructor(args: DevUIAppContextArgs);
    getDevUIUrl(): string;
    getOpenApiPath(): string;
    getCurrentUser(): User;
    getAllUsers(): User[];
    switchUser(userId: string): void;
    onUserChange(listener: UserChangeListener): UnSubscribeHandler;
    isWorkflow(): boolean;
    getIsStunnerEnabled(): boolean;
    get isProcessEnabled(): boolean;
    get isTracingEnabled(): boolean;
    get isStunnerEnabled(): boolean;
    get availablePages(): string[];
    get customLabels(): CustomLabels;
    get omittedProcessTimelineEvents(): string[];
    get diagramPreviewSize(): DiagramPreviewSize;
}
declare const RuntimeToolsDevUIAppContext: React.Context<DevUIAppContext>;
export default RuntimeToolsDevUIAppContext;
export declare const useDevUIAppContext: () => DevUIAppContext;
