"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_router_dom_1 = require("react-router-dom");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var process_list_1 = require("@kogito-apps/process-list");
var ProcessList_1 = require("../../../channel/ProcessList");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var CloudEventFormPage_1 = require("../../pages/CloudEventFormPage/CloudEventFormPage");
var ProcessListContainer = function (_a) {
    var initialState = _a.initialState, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, ProcessList_1.useProcessListGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    (0, react_1.useEffect)(function () {
        var onOpenInstanceUnsubscriber = gatewayApi.onOpenProcessListen({
            onOpen: function (process) {
                history.push({
                    pathname: "/Process/".concat(process.id),
                    state: gatewayApi.processListState
                });
            }
        });
        var onTriggerCloudEventUnsubscriber = appContext.isWorkflow()
            ? gatewayApi.onOpenTriggerCloudEventListen({
                onOpen: function (processInstance) {
                    var _a;
                    history.push({
                        pathname: "/Processes/CloudEvent/".concat((_a = processInstance === null || processInstance === void 0 ? void 0 : processInstance.id) !== null && _a !== void 0 ? _a : ''),
                        state: {
                            source: CloudEventFormPage_1.CloudEventPageSource.INSTANCES
                        }
                    });
                }
            })
            : undefined;
        return function () {
            onOpenInstanceUnsubscriber.unSubscribe();
            onTriggerCloudEventUnsubscriber === null || onTriggerCloudEventUnsubscriber === void 0 ? void 0 : onTriggerCloudEventUnsubscriber.unSubscribe();
        };
    }, []);
    return ((0, jsx_runtime_1.jsx)(process_list_1.EmbeddedProcessList, __assign({}, (0, ouia_tools_1.componentOuiaProps)(ouiaId, 'process-list-container', ouiaSafe), { driver: gatewayApi, targetOrigin: appContext.getDevUIUrl(), initialState: initialState, singularProcessLabel: appContext.customLabels.singularProcessLabel, pluralProcessLabel: appContext.customLabels.pluralProcessLabel, isTriggerCloudEventEnabled: appContext.isWorkflow(), isWorkflow: appContext.isWorkflow() })));
};
exports.default = ProcessListContainer;
//# sourceMappingURL=ProcessListContainer.js.map