"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var FormDetailsContext_1 = require("../../../channel/FormDetails/FormDetailsContext");
var form_details_1 = require("@kogito-apps/form-details");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var FormDetailsContainer = function (_a) {
    var formData = _a.formData, onSuccess = _a.onSuccess, onError = _a.onError, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, FormDetailsContext_1.useFormDetailsGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    return ((0, jsx_runtime_1.jsx)(form_details_1.EmbeddedFormDetails, __assign({}, (0, ouia_tools_1.componentOuiaProps)(ouiaId, 'form-details-container', ouiaSafe), { driver: {
            getFormContent: function (formName) {
                return gatewayApi.getFormContent(formName);
            },
            saveFormContent: function (formName, content) {
                gatewayApi
                    .saveFormContent(formName, content)
                    .then(function (value) { return onSuccess(); })
                    .catch(function (error) {
                    var message = error.response
                        ? error.response.data
                        : error.message;
                    onError(message);
                });
            }
        }, targetOrigin: appContext.getDevUIUrl(), formData: formData })));
};
exports.default = FormDetailsContainer;
//# sourceMappingURL=FormDetailsContainer.js.map