"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_core_1 = require("@patternfly/react-core");
var react_router_dom_1 = require("react-router-dom");
var ouia_tools_1 = require("@kogito-apps/ouia-tools");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var DevUINav = function (_a) {
    var pathname = _a.pathname;
    var _b = (0, DevUIAppContext_1.useDevUIAppContext)(), isProcessEnabled = _b.isProcessEnabled, isTracingEnabled = _b.isTracingEnabled, customLabels = _b.customLabels, availablePages = _b.availablePages;
    return ((0, jsx_runtime_1.jsx)(react_core_1.Nav, __assign({ "aria-label": "Nav", theme: "dark" }, { children: (0, jsx_runtime_1.jsxs)(react_core_1.NavList, { children: [isProcessEnabled && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(!availablePages || availablePages.includes('Processes')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname === '/Processes' }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/Processes" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'processes-nav'), { children: customLabels.pluralProcessLabel })) }), 'processes-nav')), (!availablePages || availablePages.includes('Jobs')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname === '/JobsManagement' }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/JobsManagement" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'jobs-management-nav'), { children: "Jobs" })) }), 'jobs-management-nav')), (!availablePages || availablePages.includes('Tasks')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname === '/TaskInbox' }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/TaskInbox" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'task-inbox-nav'), { children: "Tasks" })) }), 'task-inbox-nav')), (!availablePages || availablePages.includes('Forms')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname === '/Forms' }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/Forms" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'forms-list-nav'), { children: "Forms" })) }), 'forms-list-nav')), (!availablePages || availablePages.includes('Monitoring')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname.startsWith('/Monitoring') }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/Monitoring" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'monitoring-nav'), { children: "Monitoring" })) }), 'monitoring-nav')), (!availablePages ||
                            availablePages.includes('CustomDashboard')) && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname.startsWith('/CustomDashboard') }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/CustomDashboard" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'customDashboard-nav'), { children: "Dashboards" })) }), 'customDashboard-nav'))] })), isTracingEnabled && ((0, jsx_runtime_1.jsx)(react_core_1.NavItem, __assign({ isActive: pathname.startsWith('/Audit') }, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Link, __assign({ to: "/Audit" }, (0, ouia_tools_1.ouiaAttribute)('data-ouia-navigation-name', 'audit-nav'), { children: "Audit investigation" })) }), 'audit-nav'))] }) })));
};
exports.default = DevUINav;
//# sourceMappingURL=DevUINav.js.map