import { GraphQL } from '@kogito-apps/consoles-common';
import { BulkProcessInstanceActionResponse, NodeInstance, OperationType, ProcessInstance, TriggerableNode } from '@kogito-apps/management-console-shared';
import { FormInfo } from '@kogito-apps/forms-list';
import { Form, FormContent } from '@kogito-apps/form-details';
import { ProcessDefinition } from '@kogito-apps/process-definition-list';
import { CustomDashboardInfo } from '@kogito-apps/custom-dashboard-list';
import { CloudEventRequest } from '@kogito-apps/cloud-event-form/dist';
export declare const performMultipleCancel: (jobsToBeActioned: (GraphQL.Job & {
    errorMessage?: string;
})[]) => Promise<{
    successJobs: any[];
    failedJobs: any[];
}>;
export declare const jobCancel: (job: Pick<GraphQL.Job, 'id' | 'endpoint'>) => Promise<{
    modalTitle: string;
    modalContent: string;
}>;
export declare const handleJobReschedule: (job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
    modalTitle: string;
    modalContent: string;
}>;
export declare const getSvg: (data: ProcessInstance) => Promise<any>;
export declare const handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
export declare const handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
export declare const handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
export declare const handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType) => Promise<BulkProcessInstanceActionResponse>;
export declare const getTriggerableNodes: (processInstance: ProcessInstance) => Promise<TriggerableNode[]>;
export declare const handleNodeTrigger: (processInstance: ProcessInstance, node: TriggerableNode) => Promise<void>;
export declare const handleProcessVariableUpdate: (processInstance: ProcessInstance, updatedJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
export declare const handleNodeInstanceCancel: (processInstance: ProcessInstance, node: NodeInstance) => Promise<void>;
export declare const handleNodeInstanceRetrigger: (processInstance: Pick<ProcessInstance, 'id' | 'serviceUrl' | 'processId'>, node: Pick<NodeInstance, 'id'>) => Promise<void>;
export declare const getForms: (formFilter: string[]) => Promise<FormInfo[]>;
export declare const getFormContent: (formName: string) => Promise<Form>;
export declare const saveFormContent: (formName: string, content: FormContent) => Promise<void>;
export declare const getProcessDefinitionList: (devUIUrl: string, openApiPath: string) => Promise<ProcessDefinition[]>;
export declare const getProcessSchema: (processDefinitionData: ProcessDefinition) => Promise<Record<string, any>>;
export declare const startProcessInstance: (formData: any, businessKey: string, processDefinitionData: ProcessDefinition) => Promise<string>;
export declare const triggerStartCloudEvent: (event: CloudEventRequest, devUIUrl: string) => Promise<string>;
export declare const triggerCloudEvent: (event: CloudEventRequest, devUIUrl: string) => Promise<any>;
export declare const startWorkflowRest: (data: Record<string, any>, endpoint: string, businessKey: string) => Promise<string>;
export declare const getCustomDashboard: (customDashboardFilter: string[]) => Promise<CustomDashboardInfo[]>;
export declare const getCustomDashboardContent: (name: string) => Promise<string>;
export declare const getCustomWorkflowSchema: (devUIUrl: string, openApiPath: string, workflowName: string) => Promise<Record<string, any>>;
