"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphQLTaskInboxQueries = void 0;
var consoles_common_1 = require("@kogito-apps/consoles-common");
var QueryUtils_1 = require("../../utils/QueryUtils");
var GraphQLTaskInboxQueries = (function () {
    function GraphQLTaskInboxQueries(client) {
        this.client = client;
    }
    GraphQLTaskInboxQueries.prototype.getUserTaskById = function (taskId) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.client
                .query({
                query: consoles_common_1.GraphQL.GetUserTaskByIdDocument,
                variables: {
                    id: taskId
                },
                fetchPolicy: 'network-only'
            })
                .then(function (value) {
                if (value.data.UserTaskInstances &&
                    value.data.UserTaskInstances.length > 0) {
                    resolve(value.data.UserTaskInstances[0]);
                    return;
                }
                resolve(undefined);
            })
                .catch(function (reason) { return reject(reason); });
        });
    };
    GraphQLTaskInboxQueries.prototype.getUserTasks = function (user, offset, limit, filters, sortBy) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.client
                .query({
                query: consoles_common_1.GraphQL.GetTasksForUserDocument,
                variables: {
                    whereArgument: (0, QueryUtils_1.buildTaskInboxWhereArgument)(user, filters),
                    offset: offset,
                    limit: limit,
                    orderBy: (0, QueryUtils_1.getOrderByObject)(sortBy)
                },
                fetchPolicy: 'network-only'
            })
                .then(function (value) {
                resolve(value.data.UserTaskInstances);
            })
                .catch(function (reason) { return reject(reason); });
        });
    };
    return GraphQLTaskInboxQueries;
}());
exports.GraphQLTaskInboxQueries = GraphQLTaskInboxQueries;
//# sourceMappingURL=TaskInboxQueries.js.map