import { ApolloClient } from 'apollo-client';
import { SortBy, QueryFilter } from '@kogito-apps/task-inbox';
import { UserTaskInstance } from '@kogito-apps/task-console-shared';
import { User } from '@kogito-apps/consoles-common';
export interface TaskInboxQueries {
    getUserTaskById(taskId: string): Promise<UserTaskInstance>;
    getUserTasks(user: User, start: number, end: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
}
export declare class GraphQLTaskInboxQueries implements TaskInboxQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getUserTaskById(taskId: string): Promise<UserTaskInstance>;
    getUserTasks(user: User, offset: number, limit: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
}
