"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskInboxGatewayApiImpl = void 0;
var TaskInboxGatewayApiImpl = (function () {
    function TaskInboxGatewayApiImpl(queries, getCurrentUser) {
        this.listeners = [];
        this.getCurrentUser = getCurrentUser;
        this.queries = queries;
    }
    Object.defineProperty(TaskInboxGatewayApiImpl.prototype, "taskInboxState", {
        get: function () {
            return this._taskInboxState;
        },
        enumerable: false,
        configurable: true
    });
    TaskInboxGatewayApiImpl.prototype.setInitialState = function (taskInboxState) {
        this._taskInboxState = taskInboxState;
        return Promise.resolve();
    };
    TaskInboxGatewayApiImpl.prototype.clearOpenTask = function () {
        this.activeTask = null;
        return Promise.resolve();
    };
    TaskInboxGatewayApiImpl.prototype.openTask = function (task) {
        this.activeTask = task;
        this.listeners.forEach(function (listener) { return listener.onOpen(task); });
        return Promise.resolve();
    };
    TaskInboxGatewayApiImpl.prototype.applyFilter = function (filter) {
        this._taskInboxState.filters = filter;
        return Promise.resolve();
    };
    TaskInboxGatewayApiImpl.prototype.applySorting = function (sortBy) {
        this._taskInboxState.sortBy = sortBy;
        return Promise.resolve();
    };
    TaskInboxGatewayApiImpl.prototype.getTaskById = function (taskId) {
        if (this.activeTask && this.activeTask.id === taskId) {
            return Promise.resolve(this.activeTask);
        }
        return this.queries.getUserTaskById(taskId);
    };
    TaskInboxGatewayApiImpl.prototype.query = function (offset, limit) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getUserTasks(_this.getCurrentUser(), offset, limit, _this._taskInboxState.filters, _this._taskInboxState.sortBy)
                .then(function (value) {
                _this._taskInboxState.currentPage = { offset: offset, limit: limit };
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    TaskInboxGatewayApiImpl.prototype.onOpenTaskListen = function (listener) {
        var _this = this;
        this.listeners.push(listener);
        var unSubscribe = function () {
            var index = _this.listeners.indexOf(listener);
            if (index > -1) {
                _this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    return TaskInboxGatewayApiImpl;
}());
exports.TaskInboxGatewayApiImpl = TaskInboxGatewayApiImpl;
//# sourceMappingURL=TaskInboxGatewayApi.js.map