import { QueryFilter, SortBy, TaskInboxState } from '@kogito-apps/task-inbox';
import { UserTaskInstance } from '@kogito-apps/task-console-shared';
import { TaskInboxQueries } from './TaskInboxQueries';
import { User } from '@kogito-apps/consoles-common';
export interface TaskInboxGatewayApi {
    taskInboxState: TaskInboxState;
    setInitialState: (initialState: TaskInboxState) => Promise<void>;
    applyFilter(filter: QueryFilter): Promise<void>;
    applySorting(sortBy: SortBy): Promise<void>;
    query(offset: number, limit: number): Promise<UserTaskInstance[]>;
    getTaskById(uuid: string): Promise<UserTaskInstance>;
    openTask: (userTask: UserTaskInstance) => void;
    clearOpenTask: () => Promise<void>;
    onOpenTaskListen: (listener: OnOpenTaskListener) => UnSubscribeHandler;
}
export interface OnOpenTaskListener {
    onOpen: (userTask: UserTaskInstance) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class TaskInboxGatewayApiImpl implements TaskInboxGatewayApi {
    private readonly listeners;
    private getCurrentUser;
    private readonly queries;
    private _taskInboxState;
    private activeTask;
    constructor(queries: TaskInboxQueries, getCurrentUser: () => User);
    get taskInboxState(): TaskInboxState;
    setInitialState(taskInboxState: TaskInboxState): Promise<void>;
    clearOpenTask(): Promise<void>;
    openTask(task: UserTaskInstance): Promise<void>;
    applyFilter(filter: QueryFilter): Promise<void>;
    applySorting(sortBy: SortBy): Promise<void>;
    getTaskById(taskId: string): Promise<UserTaskInstance>;
    query(offset: number, limit: number): Promise<UserTaskInstance[]>;
    onOpenTaskListen(listener: OnOpenTaskListener): UnSubscribeHandler;
}
