import { ApolloClient } from 'apollo-client';
import { SortBy, ProcessInstanceFilter } from '@kogito-apps/process-list';
import { BulkProcessInstanceActionResponse, OperationType, ProcessInstance } from '@kogito-apps/management-console-shared';
export interface ProcessListQueries {
    getProcessInstances(start: number, end: number, filters: ProcessInstanceFilter, sortBy: SortBy): Promise<ProcessInstance[]>;
    getChildProcessInstances(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleProcessMultipleAction(processInstances: ProcessInstance[], operationType: OperationType): Promise<BulkProcessInstanceActionResponse>;
}
export declare class GraphQLProcessListQueries implements ProcessListQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getProcessInstances(offset: number, limit: number, filters: ProcessInstanceFilter, sortBy: SortBy): Promise<ProcessInstance[]>;
    getChildProcessInstances(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleProcessMultipleAction(processInstances: ProcessInstance[], operationType: OperationType): Promise<BulkProcessInstanceActionResponse>;
}
