import { ProcessInstanceFilter, SortBy } from '@kogito-apps/process-list';
import { BulkProcessInstanceActionResponse, OperationType, ProcessInstance } from '@kogito-apps/management-console-shared';
import { ProcessListQueries } from './ProcessListQueries';
export interface ProcessListGatewayApi {
    processListState: ProcessListState;
    initialLoad: (filter: ProcessInstanceFilter, sortBy: SortBy) => Promise<void>;
    openProcess: (process: ProcessInstance) => Promise<void>;
    applyFilter: (filter: ProcessInstanceFilter) => Promise<void>;
    applySorting: (SortBy: SortBy) => Promise<void>;
    handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType) => Promise<BulkProcessInstanceActionResponse>;
    query(offset: number, limit: number): Promise<ProcessInstance[]>;
    getChildProcessesQuery(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    openTriggerCloudEvent: (processInstance?: ProcessInstance) => void;
    onOpenProcessListen: (listener: OnOpenProcessListener) => UnSubscribeHandler;
    onOpenTriggerCloudEventListen: (listener: OnOpenTriggerCloudEventListener) => UnSubscribeHandler;
}
export interface ProcessListState {
    filters: ProcessInstanceFilter;
    sortBy: SortBy;
}
export interface OnOpenProcessListener {
    onOpen: (process: ProcessInstance) => void;
}
export interface OnOpenTriggerCloudEventListener {
    onOpen: (process?: ProcessInstance) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class ProcessListGatewayApiImpl implements ProcessListGatewayApi {
    private readonly onOpenProcessListeners;
    private readonly onOpenTriggerCloudEventListeners;
    private readonly queries;
    private _ProcessListState;
    constructor(queries: ProcessListQueries);
    get processListState(): ProcessListState;
    openProcess: (process: ProcessInstance) => Promise<void>;
    initialLoad: (filter: ProcessInstanceFilter, sortBy: SortBy) => Promise<void>;
    applyFilter: (filter: ProcessInstanceFilter) => Promise<void>;
    applySorting: (sortBy: SortBy) => Promise<void>;
    handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType) => Promise<BulkProcessInstanceActionResponse>;
    query(offset: number, limit: number): Promise<ProcessInstance[]>;
    getChildProcessesQuery(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    onOpenProcessListen(listener: OnOpenProcessListener): UnSubscribeHandler;
    onOpenTriggerCloudEventListen(listener: OnOpenTriggerCloudEventListener): UnSubscribeHandler;
    openTriggerCloudEvent(processInstance?: ProcessInstance): void;
}
